/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.server;

import ch.systemsx.cisd.openbis.dss.generic.server.FileTabularDataGraphServlet;
import ch.systemsx.cisd.openbis.dss.generic.server.graph.TabularDataGraphCollectionConfiguration;
import ch.systemsx.cisd.openbis.dss.generic.server.graph.TabularDataGraphConfiguration;
import java.util.Enumeration;
import java.util.Properties;
import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServletRequest;

public class DynamicFileTabularDataGraphServlet
extends FileTabularDataGraphServlet {
    private static final String DYNAMIC_GRAPH_NAME = "dynamic";
    private static final String PARAM_TITLE = "title";
    private static final String PARAM_X_AXIS_COLUMN = "col-x";
    private static final String PARAM_Y_AXIS_COLUMN = "col-y";
    private static final String PARAM_X_AXIS_LABEL = "label-x";
    private static final String PARAM_Y_AXIS_LABEL = "label-y";
    private static final String PARAM_IMAGE_HEIGHT = "image-height";
    private static final String PARAM_IMAGE_WIDTH = "image-width";
    private static final String PARAM_GRAPH_TYPE = "graph-type";
    private static final String PARAM_GRAPH_NAME = "graph-name";
    private static final String PARAM_DELIMITER = "delimiter";
    private static final String PARAM_Z_AXIS_COLUMN = "col-z";
    private static final String PARAM_BINS = "bins";
    private static final long serialVersionUID = 1L;
    private TabularDataGraphCollectionConfiguration commonConfig;

    @Override
    protected TabularDataGraphCollectionConfiguration getConfiguration(HttpServletRequest request) {
        String yColumn;
        String name = request.getParameter(PARAM_GRAPH_NAME);
        TabularDataGraphCollectionConfiguration.DynamicTabularDataGraphCollectionConfiguration config = new TabularDataGraphCollectionConfiguration.DynamicTabularDataGraphCollectionConfiguration();
        Properties props = new Properties();
        if (name != null) {
            TabularDataGraphConfiguration graphConfig = this.commonConfig.getGraphConfiguration(name);
            props.setProperty(PARAM_TITLE, graphConfig.getTitle());
            props.setProperty("x-axis", graphConfig.getTitle());
            props.setProperty("y-axis", graphConfig.getTitle());
            props.setProperty(PARAM_GRAPH_TYPE, graphConfig.getGraphType().toString());
            config.setImageHeight(graphConfig.getImageHeight());
            config.setImageWidth(graphConfig.getImageWidth());
            config.setColumnDelimiter(this.commonConfig.getColumnDelimiter());
        } else {
            name = DYNAMIC_GRAPH_NAME;
        }
        String delimiter = request.getParameter(PARAM_DELIMITER);
        if (delimiter != null && delimiter.toCharArray().length > 0) {
            config.setColumnDelimiter(delimiter.toCharArray()[0]);
        }
        props.setProperty("graphs", name);
        this.propertyOverride(PARAM_TITLE, PARAM_TITLE, props, name, request);
        String xColumn = this.propertyOverride("x-axis", PARAM_X_AXIS_COLUMN, props, name, request);
        if (xColumn != null && xColumn.indexOf("<") == -1) {
            this.propertyOverride("x-axis", props, name, "<" + xColumn + ">" + request.getParameter(PARAM_X_AXIS_LABEL));
        }
        if ((yColumn = this.propertyOverride("y-axis", PARAM_Y_AXIS_COLUMN, props, name, request)) != null && yColumn.indexOf("<") == -1) {
            this.propertyOverride("y-axis", props, name, "<" + yColumn + ">" + request.getParameter(PARAM_Y_AXIS_LABEL));
        }
        this.propertyOverride(PARAM_GRAPH_TYPE, PARAM_GRAPH_TYPE, props, name, request);
        int width = this.parsePositiveInt(this.propertyOverride(PARAM_IMAGE_WIDTH, PARAM_IMAGE_WIDTH, props, name, request));
        int height = this.parsePositiveInt(this.propertyOverride(PARAM_IMAGE_HEIGHT, PARAM_IMAGE_HEIGHT, props, name, request));
        if (width > 0) {
            config.setImageWidth(width);
        }
        if (height > 0) {
            config.setImageHeight(height);
        }
        this.propertyOverride("column", PARAM_Z_AXIS_COLUMN, props, name, request);
        this.propertyOverride("number-of-bins", PARAM_BINS, props, name, request);
        config.setProperties(props);
        return TabularDataGraphCollectionConfiguration.getConfiguration(config);
    }

    private String propertyOverride(String propertyName, String parameterName, Properties props, String name, HttpServletRequest request) {
        String value = request.getParameter(parameterName);
        return this.propertyOverride(propertyName, props, name, value);
    }

    private String propertyOverride(String propertyName, Properties props, String name, String value) {
        if (value != null && !value.trim().isEmpty()) {
            props.setProperty(name + "." + propertyName, value);
            return value;
        }
        return props.getProperty(name + "." + propertyName);
    }

    private int parsePositiveInt(String string) {
        if (string == null || string.isEmpty()) {
            return -1;
        }
        try {
            int value = Integer.parseInt(string);
            if (value < 1) {
                return -1;
            }
            return value;
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    @Override
    protected synchronized void doSpecificInitialization(Enumeration<String> parameterNames, ServletConfig servletConfig) {
        String propertiesFilePath;
        if (this.commonConfig == null && (propertiesFilePath = servletConfig.getInitParameter("properties-file")) != null) {
            this.commonConfig = TabularDataGraphCollectionConfiguration.getConfiguration(propertiesFilePath);
        }
    }
}

