/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.server;

import ch.systemsx.cisd.openbis.dss.generic.server.DataStoreServer;
import java.io.IOException;
import java.util.Locale;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.util.StringUtils;
import org.springframework.web.HttpRequestHandler;
import org.springframework.web.HttpRequestMethodNotSupportedException;

public class HttpInvokerServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private final HttpRequestHandler target;
    private final String description;

    public HttpInvokerServlet(HttpRequestHandler target, String description) {
        this.target = target;
        this.description = description;
    }

    public void init() throws ServletException {
        DataStoreServer.operationLog.info((Object)("[http-invoker] RPC service available at " + this.description));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        LocaleContextHolder.setLocale((Locale)request.getLocale());
        try {
            this.target.handleRequest(request, response);
        }
        catch (HttpRequestMethodNotSupportedException ex) {
            Object[] supportedMethods = ex.getSupportedMethods();
            if (supportedMethods != null) {
                response.setHeader("Allow", StringUtils.arrayToDelimitedString((Object[])supportedMethods, (String)", "));
            }
            response.sendError(405, ex.getMessage());
        }
        finally {
            LocaleContextHolder.resetLocaleContext();
        }
    }
}

