/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.server;

import ch.systemsx.cisd.common.exceptions.InvalidSessionException;
import ch.systemsx.cisd.openbis.generic.shared.IServiceForDataStoreServer;
import java.util.HashSet;
import java.util.Set;

public class OpenbisSessionTokenCache {
    private final IServiceForDataStoreServer service;
    private final Set<String> sessionTokens = new HashSet<String>();

    public OpenbisSessionTokenCache(IServiceForDataStoreServer service) {
        this.service = service;
    }

    public boolean isValidSessionToken(String sessionToken) {
        if (this.sessionTokens.contains(sessionToken)) {
            return true;
        }
        try {
            this.service.checkSession(sessionToken);
            this.sessionTokens.add(sessionToken);
            return true;
        }
        catch (InvalidSessionException ex) {
            return false;
        }
    }

    public void removeSessionToken(String sessionToken) {
        this.sessionTokens.remove(sessionToken);
    }
}

