/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.server;

import ch.systemsx.cisd.openbis.dss.generic.server.DirectoryRendererUtil;
import ch.systemsx.cisd.openbis.dss.generic.server.IDirectoryRenderer;
import ch.systemsx.cisd.openbis.dss.generic.server.IErrorRenderer;
import ch.systemsx.cisd.openbis.dss.generic.server.IMessageRenderer;
import ch.systemsx.cisd.openbis.dss.generic.server.IRendererFactory;
import ch.systemsx.cisd.openbis.dss.generic.server.RenderingContext;
import java.io.PrintWriter;

public class PlainTextRendererFactory
implements IRendererFactory {
    @Override
    public IDirectoryRenderer createDirectoryRenderer(RenderingContext context) {
        return new PlainTextDirectoryRenderer();
    }

    @Override
    public IErrorRenderer createErrorRenderer() {
        return new IErrorRenderer(){
            private PrintWriter writer;

            @Override
            public void printErrorMessage(String errorMessage) {
                this.writer.println("Error:");
                this.writer.println(errorMessage);
            }

            @Override
            public void setWriter(PrintWriter writer) {
                this.writer = writer;
            }
        };
    }

    @Override
    public String getContentType() {
        return "text";
    }

    @Override
    public IMessageRenderer createMessageRenderer() {
        return new IMessageRenderer(){
            private PrintWriter writer;

            @Override
            public void printMessage(String message) {
                this.writer.println(message);
            }

            @Override
            public void setWriter(PrintWriter writer) {
                this.writer = writer;
            }
        };
    }

    private static class PlainTextDirectoryRenderer
    implements IDirectoryRenderer {
        private PrintWriter writer;

        private PlainTextDirectoryRenderer() {
        }

        @Override
        public void printDirectory(String name, String relativePath, long size, Boolean disableLinks) {
            this.writer.format("%s\t%s\n", name, DirectoryRendererUtil.renderFileSize(size));
        }

        @Override
        public void printFile(String name, String relativePath, long size, Integer checksumOrNull, Boolean disableLinks) {
            this.writer.format("%s\t%s\t%s\n", name, DirectoryRendererUtil.renderFileSize(size), DirectoryRendererUtil.renderCRC32Checksum(checksumOrNull));
        }

        @Override
        public void printFooter() {
        }

        @Override
        public void printHeader() {
            this.writer.println("Directory content:");
        }

        @Override
        public void printLinkToParentDirectory(String relativePath, Boolean disableLinks) {
        }

        @Override
        public void setWriter(PrintWriter writer) {
            this.writer = writer;
        }
    }
}

