/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.server;

import ch.systemsx.cisd.openbis.common.io.hierarchical_content.api.IHierarchicalContent;
import ch.systemsx.cisd.openbis.common.io.hierarchical_content.api.IHierarchicalContentNode;
import org.apache.commons.lang3.builder.ToStringBuilder;

final class RenderingContext {
    private final IHierarchicalContent rootContent;
    private final String relativePath;
    private final IHierarchicalContentNode fileNode;
    private final String urlPrefix;
    private String relativeParentPath;
    private final String sessionIdOrNull;

    RenderingContext(IHierarchicalContent rootContent, String urlPrefix, String relativePath, String sessionIdOrNull) {
        this.rootContent = rootContent;
        this.relativePath = relativePath;
        this.urlPrefix = urlPrefix;
        this.sessionIdOrNull = sessionIdOrNull;
        if (relativePath.length() > 0) {
            this.fileNode = rootContent.getNode(relativePath);
            this.relativeParentPath = this.fileNode.getParentRelativePath();
            if (this.relativeParentPath == null) {
                this.relativeParentPath = "";
            }
        } else {
            this.fileNode = rootContent.getRootNode();
        }
    }

    RenderingContext(RenderingContext oldContext, String newRelativePathOrNull) {
        this(oldContext.rootContent, oldContext.urlPrefix, newRelativePathOrNull, oldContext.sessionIdOrNull);
    }

    public final IHierarchicalContent getRootContent() {
        return this.rootContent;
    }

    public final IHierarchicalContentNode getRootNode() {
        return this.rootContent.getRootNode();
    }

    public final IHierarchicalContentNode getContentNode() {
        return this.fileNode;
    }

    public final String getRelativePath() {
        return this.relativePath;
    }

    public final String getUrlPrefix() {
        return this.urlPrefix;
    }

    public final String getRelativeParentPath() {
        return this.relativeParentPath;
    }

    public String getSessionIdOrNull() {
        return this.sessionIdOrNull;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }
}

