/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.server;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;

public class ResponseContentStream {
    protected static final String CONTENT_TYPE_PNG = "image/png";
    private final InputStream inputStream;
    private final long size;
    private final String contentType;
    private final String headerContentDisposition;

    public static final ResponseContentStream createPNG(BufferedImage image, String fileNameOrNull) throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)image, "png", output);
        ByteArrayInputStream inputStream = new ByteArrayInputStream(output.toByteArray());
        long responseSize = output.size();
        String contentType = CONTENT_TYPE_PNG;
        return ResponseContentStream.create(inputStream, responseSize, contentType, fileNameOrNull);
    }

    public static final ResponseContentStream create(InputStream inputStream, long responseSize, String contentType, String fileNameOrNull) {
        String headerContentDisposition = "inline;";
        if (fileNameOrNull != null) {
            headerContentDisposition = headerContentDisposition + " filename=\"" + fileNameOrNull + "\"";
        }
        return new ResponseContentStream(inputStream, responseSize, contentType, headerContentDisposition);
    }

    private ResponseContentStream(InputStream inputStream, long size, String contentType, String headerContentDisposition) {
        this.inputStream = inputStream;
        this.size = size;
        this.contentType = contentType;
        this.headerContentDisposition = headerContentDisposition;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public long getSize() {
        return this.size;
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getHeaderContentDisposition() {
        return this.headerContentDisposition;
    }
}

