/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.server;

import ch.systemsx.cisd.common.spring.PropertyPlaceholderUtils;
import ch.systemsx.cisd.openbis.common.conversation.client.ServiceConversationClientDetails;
import ch.systemsx.cisd.openbis.common.conversation.manager.BaseServiceConversationServerManager;
import ch.systemsx.cisd.openbis.dss.generic.server.ConfigParameters;
import ch.systemsx.cisd.openbis.dss.generic.server.IServiceConversationServerManagerLocal;
import ch.systemsx.cisd.openbis.generic.shared.IDataStoreService;
import ch.systemsx.cisd.openbis.generic.shared.conversation.ServiceConversationApplicationServerClientId;
import ch.systemsx.cisd.openbis.generic.shared.conversation.ServiceConversationApplicationServerUrl;
import org.springframework.beans.factory.InitializingBean;

public class ServiceConversationServerManager
extends BaseServiceConversationServerManager
implements IServiceConversationServerManagerLocal,
InitializingBean {
    private IDataStoreService dataStoreService;
    private ServiceConversationApplicationServerUrl applicationServerUrl;
    private int applicationServerTimeoutInMillis;

    public void afterPropertiesSet() throws Exception {
        this.addService(IDataStoreService.class, this.dataStoreService);
    }

    protected ServiceConversationClientDetails getClientDetailsForClientId(Object clientId) {
        if (clientId instanceof ServiceConversationApplicationServerClientId) {
            return new ServiceConversationClientDetails(this.applicationServerUrl.getClientUrl(this.applicationServerTimeoutInMillis), this.applicationServerTimeoutInMillis);
        }
        return null;
    }

    public void setDataStoreService(IDataStoreService dataStoreService) {
        this.dataStoreService = dataStoreService;
    }

    public void setApplicationServerUrl(String applicationServerUrl) {
        this.applicationServerUrl = new ServiceConversationApplicationServerUrl(applicationServerUrl);
    }

    public void setApplicationServerTimeout(String applicationServerTimeout) {
        this.applicationServerTimeoutInMillis = PropertyPlaceholderUtils.getInteger((String)applicationServerTimeout, (Integer)ConfigParameters.getDefaultServerTimeoutInMinutes()) * 60 * 1000;
    }
}

