/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.server;

import ch.systemsx.cisd.common.servlet.HttpServletRequestUtils;
import ch.systemsx.cisd.openbis.dss.generic.shared.ServiceProvider;
import ch.systemsx.cisd.openbis.dss.generic.shared.api.v1.IDssServiceRpcGeneric;
import com.marathon.util.spring.StreamSupportingHttpInvokerServiceExporter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLConnection;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;

public class SessionWorkspaceFileDownloadServlet
extends HttpServlet {
    private static final String FILE_PATH_PARAM = "filePath";
    private static final long serialVersionUID = 1L;
    private IDssServiceRpcGeneric service;

    public final void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        StreamSupportingHttpInvokerServiceExporter serviceExporter = ServiceProvider.getDssServiceRpcGeneric();
        this.service = (IDssServiceRpcGeneric)serviceExporter.getService();
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        SessionWorkspaceFileDownloadRequest downloadRequest = new SessionWorkspaceFileDownloadRequest(request);
        downloadRequest.validate();
        InputStream fileStream = this.service.getFileFromSessionWorkspace(downloadRequest.getSessionId(), downloadRequest.getFilePath());
        SessionWorkspaceFileDownloadResponse downloadResponse = new SessionWorkspaceFileDownloadResponse(response);
        downloadResponse.writeFile(downloadRequest.getFilePath(), fileStream);
    }

    private class SessionWorkspaceFileDownloadResponse {
        private HttpServletResponse response;

        public SessionWorkspaceFileDownloadResponse(HttpServletResponse response) {
            this.response = response;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void writeFile(String filePath, InputStream fileStream) throws IOException {
            ServletOutputStream outputStream = null;
            try {
                String fileName = FilenameUtils.getName((String)filePath);
                this.response.setHeader("Content-Disposition", "inline; filename=" + fileName);
                this.response.setContentType(URLConnection.guessContentTypeFromName(fileName));
                this.response.setStatus(200);
                outputStream = this.response.getOutputStream();
                IOUtils.copyLarge((InputStream)fileStream, (OutputStream)outputStream);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly((InputStream)fileStream);
                IOUtils.closeQuietly(outputStream);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)fileStream);
            IOUtils.closeQuietly((OutputStream)outputStream);
        }
    }

    private class SessionWorkspaceFileDownloadRequest {
        private HttpServletRequest request;

        public SessionWorkspaceFileDownloadRequest(HttpServletRequest request) {
            this.request = request;
        }

        public String getSessionId() {
            return HttpServletRequestUtils.getStringParameter((HttpServletRequest)this.request, (String)"sessionID");
        }

        public String getFilePath() {
            return HttpServletRequestUtils.getStringParameter((HttpServletRequest)this.request, (String)SessionWorkspaceFileDownloadServlet.FILE_PATH_PARAM);
        }

        public void validate() {
            if (this.getSessionId() == null) {
                throw new IllegalArgumentException("sessionID parameter cannot be null");
            }
            if (this.getFilePath() == null) {
                throw new IllegalArgumentException("filePath parameter cannot be null");
            }
        }
    }
}

