/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.server;

import ch.systemsx.cisd.base.exceptions.CheckedExceptionTunnel;
import ch.systemsx.cisd.openbis.dss.generic.shared.ServiceProvider;
import ch.systemsx.cisd.openbis.dss.generic.shared.api.v1.IDssServiceRpcGeneric;
import com.marathon.util.spring.StreamSupportingHttpInvokerServiceExporter;
import java.io.IOException;
import java.io.InputStream;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItemIterator;
import org.apache.commons.fileupload.FileItemStream;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.io.IOUtils;

public final class SessionWorkspaceFormUploadServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private IDssServiceRpcGeneric service;

    public final void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        StreamSupportingHttpInvokerServiceExporter serviceExporter = ServiceProvider.getDssServiceRpcGeneric();
        this.service = (IDssServiceRpcGeneric)serviceExporter.getService();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        SessionWorkspaceFormUploadRequest uploadRequest = new SessionWorkspaceFormUploadRequest(request);
        uploadRequest.validate();
        try {
            FileItemIterator iterator = uploadRequest.getFiles();
            while (iterator.hasNext()) {
                FileItemStream file = null;
                InputStream stream = null;
                try {
                    file = iterator.next();
                    stream = file.openStream();
                    this.service.putFileToSessionWorkspace(uploadRequest.getSessionId(), file.getName(), stream);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(stream);
                    throw throwable;
                    return;
                }
                IOUtils.closeQuietly((InputStream)stream);
            }
        }
        catch (FileUploadException e) {
            throw CheckedExceptionTunnel.wrapIfNecessary((Exception)((Object)e));
        }
    }

    private class SessionWorkspaceFormUploadRequest {
        private HttpServletRequest request;

        public SessionWorkspaceFormUploadRequest(HttpServletRequest request) {
            this.request = request;
        }

        public String getSessionId() {
            return this.request.getParameter("sessionID");
        }

        public FileItemIterator getFiles() throws FileUploadException, IOException {
            ServletFileUpload upload = new ServletFileUpload();
            return upload.getItemIterator(this.request);
        }

        public void validate() {
            if (!ServletFileUpload.isMultipartContent((HttpServletRequest)this.request)) {
                throw new IllegalArgumentException("The session workspace form upload accepts only multipart requests");
            }
            if (this.getSessionId() == null) {
                throw new IllegalArgumentException("sessionID parameter cannot be null");
            }
        }
    }
}

