/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.server;

import ch.systemsx.cisd.base.exceptions.CheckedExceptionTunnel;
import ch.systemsx.cisd.common.string.Template;
import ch.systemsx.cisd.openbis.dss.generic.server.DirectoryRendererUtil;
import ch.systemsx.cisd.openbis.dss.generic.server.IDirectoryRenderer;
import ch.systemsx.cisd.openbis.dss.generic.server.RenderingContext;
import ch.systemsx.cisd.openbis.dss.generic.server.Utils;
import java.io.PrintWriter;
import java.net.URI;
import org.apache.commons.lang3.StringUtils;

final class SimpleHTMLDirectoryRenderer
implements IDirectoryRenderer {
    private static final String CSS = "<style type='text/css'> * { margin: 3px; }html { height: 100%;  }body { height: 100%; font-family: verdana, tahoma, helvetica; font-size: 11px; text-align:left; }h1 { text-align: center; padding: 1em; color: #1E4E8F;}.td_hd { border: 1px solid #FFFFFF; padding 3px; background-color: #DDDDDD; height: 1.5em; }.div_hd { background-color: #1E4E8F; color: white; font-weight: bold; padding: 3px; }table { border-collapse: collapse; padding: 1em; }tr, td { font-family: verdana, tahoma, helvetica; font-size: 11px; }.td_file { font-family: verdana, tahoma, helvetica; font-size: 11px; height: 1.5em }.wrapper { min-height: 100%; height: auto !important; height: 100%; margin: 0em auto -4em; }.footer { height: 4em; text-align: center; }</style>";
    private static final Template ROW_TEMPLATE = new Template("<tr><td class='td_file'><a href='${path}?disableLinks=${disableLinks}&mode=simpleHtml${sessionId}'>${name}</a></td><td>${size}</td><td>${checksum}</td></tr>");
    private static final Template ROW_TEMPLATE_NO_LINK = new Template("<tr><td class='td_file'><span>${name}</span></td><td>${size}</td><td>${checksum}</td></tr>");
    private static final Template HEADER_TEMPLATE = new Template("<html><head><style type='text/css'> * { margin: 3px; }html { height: 100%;  }body { height: 100%; font-family: verdana, tahoma, helvetica; font-size: 11px; text-align:left; }h1 { text-align: center; padding: 1em; color: #1E4E8F;}.td_hd { border: 1px solid #FFFFFF; padding 3px; background-color: #DDDDDD; height: 1.5em; }.div_hd { background-color: #1E4E8F; color: white; font-weight: bold; padding: 3px; }table { border-collapse: collapse; padding: 1em; }tr, td { font-family: verdana, tahoma, helvetica; font-size: 11px; }.td_file { font-family: verdana, tahoma, helvetica; font-size: 11px; height: 1.5em }.wrapper { min-height: 100%; height: auto !important; height: 100%; margin: 0em auto -4em; }.footer { height: 4em; text-align: center; }</style></head><body><table> ${folder}");
    private static final Template FOOTER_TEMPLATE = new Template("</table> </div> </body></html>");
    private PrintWriter writer;
    private final String urlPrefix;
    private final String relativePath;
    private final String sessionIdOrNull;

    SimpleHTMLDirectoryRenderer(RenderingContext context) {
        this.relativePath = context.getRelativePath();
        this.sessionIdOrNull = context.getSessionIdOrNull();
        String prefix = context.getUrlPrefix();
        this.urlPrefix = prefix.endsWith("/") ? prefix : prefix + "/";
    }

    @Override
    public void setWriter(PrintWriter writer) {
        this.writer = writer;
    }

    @Override
    public void printHeader() {
        Template template = HEADER_TEMPLATE.createFreshCopy();
        if (StringUtils.isNotBlank((CharSequence)this.relativePath)) {
            template.bind("folder", "<tr><td class='td_hd'>Folder:</td><td>" + this.relativePath + "</td></tr>");
        } else {
            template.bind("folder", "");
        }
        this.writer.println(template.createText());
    }

    @Override
    public void printLinkToParentDirectory(String aRelativePath, Boolean disableLinks) {
        this.printRow("..", aRelativePath, "", "", true, disableLinks);
    }

    @Override
    public void printDirectory(String name, String aRelativePath, long size, Boolean disableLinks) {
        this.printRow(name + "/", aRelativePath, DirectoryRendererUtil.renderFileSize(size), "", true, disableLinks);
    }

    @Override
    public void printFile(String name, String aRelativePath, long size, Integer checksumOrNull, Boolean disableLinks) {
        this.printRow(name, aRelativePath, DirectoryRendererUtil.renderFileSize(size), DirectoryRendererUtil.renderCRC32Checksum(checksumOrNull), false, disableLinks);
    }

    private void printRow(String name, String aRelativePath, String fileSize, String checksum, Boolean isDirectory, Boolean disableLinks) {
        Template template = null;
        if (!isDirectory.booleanValue() && disableLinks.booleanValue()) {
            template = ROW_TEMPLATE_NO_LINK.createFreshCopy();
        } else {
            template = ROW_TEMPLATE.createFreshCopy();
            template.bind("path", this.urlPrefix + this.encodeURL(aRelativePath));
            template.bind("sessionId", Utils.createUrlParameterForSessionId("&", this.sessionIdOrNull));
            template.bind("disableLinks", disableLinks.toString());
        }
        template.bind("name", name);
        template.bind("size", fileSize);
        template.bind("checksum", checksum);
        this.writer.println(template.createText());
    }

    private String encodeURL(String url) {
        try {
            URI uri = new URI(null, null, url, null);
            return uri.getRawPath();
        }
        catch (Exception ex) {
            throw CheckedExceptionTunnel.wrapIfNecessary((Exception)ex);
        }
    }

    @Override
    public void printFooter() {
        Template template = FOOTER_TEMPLATE.createFreshCopy();
        this.writer.println(template.createText());
    }
}

