/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.server;

import ch.rinn.restrictions.Private;
import ch.systemsx.cisd.cifex.rpc.client.FileWithOverrideName;
import ch.systemsx.cisd.cifex.rpc.client.ICIFEXComponent;
import ch.systemsx.cisd.cifex.rpc.client.ICIFEXUploader;
import ch.systemsx.cisd.cifex.rpc.client.gui.IProgressListener;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.mail.MailClient;
import ch.systemsx.cisd.common.mail.MailClientParameters;
import ch.systemsx.cisd.common.security.TokenGenerator;
import ch.systemsx.cisd.common.time.TimingParameters;
import ch.systemsx.cisd.openbis.dss.generic.server.AbstractDataSetPackager;
import ch.systemsx.cisd.openbis.dss.generic.server.ICIFEXRPCServiceFactory;
import ch.systemsx.cisd.openbis.dss.generic.server.IDataSetCommand;
import ch.systemsx.cisd.openbis.dss.generic.server.ZipDataSetPackager;
import ch.systemsx.cisd.openbis.dss.generic.shared.IDataSetDirectoryProvider;
import ch.systemsx.cisd.openbis.dss.generic.shared.IHierarchicalContentProvider;
import ch.systemsx.cisd.openbis.dss.generic.shared.ServiceProvider;
import ch.systemsx.cisd.openbis.dss.generic.shared.utils.DataSetExistenceChecker;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.AbstractExternalData;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Experiment;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Project;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Sample;
import ch.systemsx.cisd.openbis.generic.shared.dto.DataSetUploadContext;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

class UploadingCommand
implements IDataSetCommand {
    private static final long serialVersionUID = 1L;
    private static final Logger operationLog = LogFactory.getLogger((LogCategory)LogCategory.OPERATION, UploadingCommand.class);
    private static final Logger notificationLog = LogFactory.getLogger((LogCategory)LogCategory.NOTIFY, UploadingCommand.class);
    private final ICIFEXRPCServiceFactory cifexServiceFactory;
    private final List<AbstractExternalData> dataSets;
    private final String fileName;
    private final String comment;
    private final String userID;
    private final String password;
    private final String userEMail;
    private final boolean userAuthenticated;
    private final String cifexAdminUserOrNull;
    private final String cifexAdminPasswordOrNull;
    private final MailClientParameters mailClientParameters;
    private final TokenGenerator tokenGenerator;
    @Private
    boolean deleteAfterUploading = true;
    @Private
    transient IHierarchicalContentProvider hierarchicalContentProvider;

    UploadingCommand(ICIFEXRPCServiceFactory cifexServiceFactory, MailClientParameters mailClientParameters, List<AbstractExternalData> dataSets, DataSetUploadContext context, String cifexAdminUserOrNull, String cifexAdminPasswordOrNull) {
        this.cifexServiceFactory = cifexServiceFactory;
        this.mailClientParameters = mailClientParameters;
        this.dataSets = dataSets;
        this.userID = context.getUserID();
        this.password = context.getPassword();
        this.userAuthenticated = context.isUserAuthenticated();
        this.cifexAdminUserOrNull = cifexAdminUserOrNull;
        this.cifexAdminPasswordOrNull = cifexAdminPasswordOrNull;
        this.fileName = context.getFileName();
        this.userEMail = context.getUserEMail();
        this.comment = context.getComment();
        this.tokenGenerator = new TokenGenerator();
    }

    @Override
    public List<String> getDataSetCodes() {
        ArrayList<String> result = new ArrayList<String>();
        for (AbstractExternalData dataSet : this.dataSets) {
            result.add(dataSet.getCode());
        }
        return result;
    }

    @Override
    public void execute(IHierarchicalContentProvider contentProvider, IDataSetDirectoryProvider dataSetDirectoryProvider) {
        File root = dataSetDirectoryProvider.getStoreRoot();
        File tempFolder = new File(root, "tmp");
        tempFolder.mkdirs();
        File zipFile = new File(tempFolder, this.createFileName());
        boolean successful = this.fillZipFile(dataSetDirectoryProvider, zipFile);
        if (successful) {
            if (operationLog.isInfoEnabled()) {
                operationLog.info((Object)("Zip file " + zipFile + " with " + this.dataSets.size() + " data sets has been successfully created."));
            }
            ICIFEXComponent cifex = this.cifexServiceFactory.createCIFEXComponent();
            String sessionToken = this.getCIFEXSession(cifex);
            ICIFEXUploader uploader = cifex.createUploader(sessionToken);
            uploader.addProgressListener((IProgressListener)new ProgressListener(zipFile));
            uploader.upload(Arrays.asList(new FileWithOverrideName(zipFile, null)), "id:" + this.userID, this.comment);
        } else {
            this.sendEMail("Couldn't create zip file " + zipFile.getName() + " with requested data sets");
        }
        if (this.deleteAfterUploading) {
            zipFile.delete();
        }
    }

    private String getCIFEXSession(ICIFEXComponent cifex) {
        return UploadingCommand.getCIFEXSession(cifex, this.userAuthenticated, this.userID, this.password, this.cifexAdminUserOrNull, this.cifexAdminPasswordOrNull);
    }

    private static String getCIFEXSession(ICIFEXComponent cifex, boolean userAuthenticated, String userID, String password, String cifexAdminUserOrNull, String cifexAdminPasswordOrNull) {
        if (userAuthenticated && StringUtils.isBlank((CharSequence)password) && StringUtils.isNotBlank((CharSequence)cifexAdminUserOrNull) && StringUtils.isNotBlank((CharSequence)cifexAdminPasswordOrNull)) {
            String token = cifex.login(cifexAdminUserOrNull, cifexAdminPasswordOrNull);
            if (operationLog.isDebugEnabled()) {
                operationLog.debug((Object)String.format("Calling setSessionUser() on CIFEX session to userID=%s", userID));
            }
            cifex.setSessionUser(token, userID);
            return token;
        }
        if (operationLog.isDebugEnabled()) {
            operationLog.debug((Object)String.format("Directly logging into CIFEX as userID=%s (user authenticated=%s, password provided=%s", userID, userAuthenticated, StringUtils.isNotBlank((CharSequence)password)));
        }
        return cifex.login(userID, password);
    }

    static boolean canLoginToCIFEX(ICIFEXComponent cifex, boolean userAuthenticated, String userID, String password, String cifexAdminUserOrNull, String cifexAdminPasswordOrNull) {
        String tokenOrNull = UploadingCommand.getCIFEXSession(cifex, userAuthenticated, userID, password, cifexAdminUserOrNull, cifexAdminPasswordOrNull);
        if (tokenOrNull != null) {
            cifex.logout(tokenOrNull);
            return true;
        }
        return false;
    }

    private String createFileName() {
        if (StringUtils.isBlank((CharSequence)this.fileName)) {
            return this.tokenGenerator.getNewToken(System.currentTimeMillis()) + ".zip";
        }
        return this.fileName.toLowerCase().endsWith(".zip") ? this.fileName : this.fileName + ".zip";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean fillZipFile(IDataSetDirectoryProvider dataSetDirectoryProvider, File zipFile) {
        AbstractDataSetPackager packager = null;
        DataSetExistenceChecker dataSetExistenceChecker = new DataSetExistenceChecker(dataSetDirectoryProvider, TimingParameters.create((Properties)new Properties()));
        try {
            packager = new ZipDataSetPackager(zipFile, true, this.getHierarchicalContentProvider(), dataSetExistenceChecker);
            for (AbstractExternalData externalData : this.dataSets) {
                String newRootPath = this.createRootPath(externalData) + "/";
                try {
                    packager.addDataSetTo(newRootPath, externalData);
                }
                catch (RuntimeException ex) {
                    notificationLog.error((Object)ex.getMessage(), (Throwable)ex);
                    boolean bl = false;
                    if (packager != null) {
                        try {
                            packager.close();
                        }
                        catch (Exception ex2) {
                            notificationLog.error((Object)"Couldn't close package", (Throwable)ex2);
                        }
                    }
                    return bl;
                }
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception ex) {
            notificationLog.error((Object)"Couldn't create zip file for uploading", (Throwable)ex);
            boolean bl = false;
            return bl;
        }
        finally {
            if (packager != null) {
                try {
                    packager.close();
                }
                catch (Exception ex) {
                    notificationLog.error((Object)"Couldn't close package", (Throwable)ex);
                }
            }
        }
    }

    private IHierarchicalContentProvider getHierarchicalContentProvider() {
        if (this.hierarchicalContentProvider == null) {
            this.hierarchicalContentProvider = ServiceProvider.getHierarchicalContentProvider();
        }
        return this.hierarchicalContentProvider;
    }

    private String createRootPath(AbstractExternalData dataSet) {
        Sample sample = dataSet.getSample();
        Experiment experiment = dataSet.getExperiment();
        if (experiment != null) {
            Project project = experiment.getProject();
            return project.getSpace().getCode() + "/" + project.getCode() + "/" + experiment.getCode() + "/" + (sample == null ? "" : sample.getCode() + "/") + dataSet.getCode();
        }
        return sample.getSpace().getCode() + "/" + sample.getCode() + "/" + dataSet.getCode();
    }

    private void sendEMail(String message) {
        MailClient mailClient = new MailClient(this.mailClientParameters);
        mailClient.sendMessage("[Data Set Server] Uploading failed", message, null, null, new String[]{this.userEMail});
    }

    @Override
    public String getType() {
        return "CIFEX Uploading";
    }

    @Override
    public String getDescription() {
        StringBuilder b = new StringBuilder();
        b.append("Upload data sets to CIFEX: ");
        for (AbstractExternalData dataset : this.dataSets) {
            b.append(dataset.getCode());
            b.append(',');
        }
        b.setLength(b.length() - 1);
        return b.toString();
    }

    private final class ProgressListener
    implements IProgressListener {
        private final File zipFile;

        private ProgressListener(File zipFile) {
            this.zipFile = zipFile;
        }

        public void start(File file, String operationName, long fileSize, Long fileIdOrNull) {
            if (operationLog.isInfoEnabled()) {
                operationLog.info((Object)("Start uploading of zip file " + file));
            }
        }

        public void reportProgress(int percentage, long numberOfBytes) {
        }

        public void finished(boolean successful) {
            if (successful) {
                if (operationLog.isInfoEnabled()) {
                    operationLog.info((Object)("Zip file " + this.zipFile + " has been successfully uploaded."));
                }
            } else {
                operationLog.warn((Object)("Uploading of zip file " + this.zipFile + " has been aborted or failed."));
                UploadingCommand.this.sendEMail("Uploading of zip file " + this.zipFile.getName() + " with requested data sets failed.");
            }
        }

        public void exceptionOccured(Throwable throwable) {
            notificationLog.error((Object)("An error occured during uploading of zip file " + this.zipFile + "."), throwable);
        }

        public void warningOccured(String warningMessage) {
            operationLog.warn((Object)warningMessage);
        }
    }
}

