/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.server.api.v2.sequencedatabases;

import ch.systemsx.cisd.common.fasta.FastaUtilities;
import ch.systemsx.cisd.common.fasta.SequenceType;
import ch.systemsx.cisd.common.filesystem.FileUtilities;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.openbis.dss.generic.server.api.v2.sequencedatabases.AbstractSearchDomainService;
import ch.systemsx.cisd.openbis.dss.generic.shared.utils.BlastUtils;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.AlignmentMatch;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.BlastScore;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.DataSetFileBlastSearchResultLocation;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.EntityKind;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.EntityPropertyBlastSearchResultLocation;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.ISearchDomainResultLocation;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.ISearchDomainResultScore;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.SearchDomainSearchResult;
import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class BlastDatabase
extends AbstractSearchDomainService {
    public static final Logger operationLog = LogFactory.getLogger((LogCategory)LogCategory.OPERATION, BlastDatabase.class);
    private static final String QUERY_FILE_NAME_TEMPLATE = "query-{0,date,yyyyMMDDHHmmssSSS}-{1}.fasta";
    private static final Pattern STITLE_PATTERN = Pattern.compile("(.*) \\[Data set: (.*), File: (.*)\\]$");
    private static final Pattern ENTITY_PROPERTY_TITLE_PATTERN = Pattern.compile("^(MATERIAL|EXPERIMENT|SAMPLE|DATA_SET)\\+(.+)\\+([A-Z0-9_\\-.]+)\\+(\\d+)$");
    private final boolean available;
    private final File queriesFolder;
    private final BlastUtils blaster;
    private AtomicInteger counter = new AtomicInteger();

    public BlastDatabase(Properties properties, File storeRoot) {
        super(properties, storeRoot);
        this.blaster = new BlastUtils(properties, storeRoot);
        this.available = this.blaster.available();
        File databaseFolder = this.blaster.getBlastDatabaseFolder(properties, storeRoot);
        this.queriesFolder = new File(databaseFolder, "queries-folder");
        this.queriesFolder.mkdirs();
    }

    @Override
    public boolean isAvailable() {
        return this.available;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<SearchDomainSearchResult> search(String sequenceSnippet, Map<String, String> optionalParametersOrNull) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        if (optionalParametersOrNull != null) {
            parameters.putAll(optionalParametersOrNull);
        }
        ArrayList<SearchDomainSearchResult> result = new ArrayList<SearchDomainSearchResult>();
        SequenceType sequenceType = FastaUtilities.determineSequenceType((String)sequenceSnippet);
        String queryFileName = new MessageFormat(QUERY_FILE_NAME_TEMPLATE).format(new Object[]{new Date(), this.counter.getAndIncrement()});
        File queryFile = new File(this.queriesFolder, queryFileName);
        try {
            FileUtilities.writeToFile((File)queryFile, (String)(">query\n" + sequenceSnippet + "\n"));
            List<String> output = this.blaster.processAndDeliverOutput(sequenceType, queryFile, this.name, parameters);
            for (String line : output) {
                Row row = new Row(line);
                SearchDomainSearchResult sequenceSearchResult = new SearchDomainSearchResult();
                sequenceSearchResult.setScore((ISearchDomainResultScore)this.createBlastScore(row));
                AlignmentMatch alignmentMatch = this.createAlignmentMatch(row);
                Matcher matcher = STITLE_PATTERN.matcher(row.title);
                if (matcher.matches()) {
                    sequenceSearchResult.setResultLocation((ISearchDomainResultLocation)this.createDataSetFileBlastSearchResultLocation(matcher, alignmentMatch));
                    result.add(sequenceSearchResult);
                    continue;
                }
                matcher = ENTITY_PROPERTY_TITLE_PATTERN.matcher(row.title);
                if (!matcher.matches()) continue;
                sequenceSearchResult.setResultLocation((ISearchDomainResultLocation)this.createEntityPropertyBlastSearchResultLocation(matcher, alignmentMatch));
                result.add(sequenceSearchResult);
            }
        }
        finally {
            FileUtilities.delete((File)queryFile);
        }
        return result;
    }

    private EntityPropertyBlastSearchResultLocation createEntityPropertyBlastSearchResultLocation(Matcher matcher, AlignmentMatch alignmentMatch) {
        EntityPropertyBlastSearchResultLocation resultLocation = new EntityPropertyBlastSearchResultLocation();
        resultLocation.setEntityKind(EntityKind.valueOf((String)matcher.group(1)));
        resultLocation.setPermId(matcher.group(2));
        resultLocation.setPropertyType(matcher.group(3));
        resultLocation.setAlignmentMatch(alignmentMatch);
        return resultLocation;
    }

    private DataSetFileBlastSearchResultLocation createDataSetFileBlastSearchResultLocation(Matcher matcher, AlignmentMatch alignmentMatch) {
        DataSetFileBlastSearchResultLocation resultLocation = new DataSetFileBlastSearchResultLocation();
        resultLocation.setIdentifier(matcher.group(1));
        resultLocation.setPermId(matcher.group(2));
        resultLocation.setEntityKind(EntityKind.DATA_SET);
        resultLocation.setPathInDataSet(matcher.group(3));
        resultLocation.setAlignmentMatch(alignmentMatch);
        return resultLocation;
    }

    private AlignmentMatch createAlignmentMatch(Row row) {
        AlignmentMatch alignmentMatch = new AlignmentMatch();
        alignmentMatch.setSequenceStart(row.sstart);
        alignmentMatch.setSequenceEnd(row.send);
        alignmentMatch.setQueryStart(row.qstart);
        alignmentMatch.setQueryEnd(row.qend);
        alignmentMatch.setNumberOfMismatches(row.numberOfMismatchs);
        alignmentMatch.setTotalNumberOfGaps(row.totalNumberOfGaps);
        return alignmentMatch;
    }

    private BlastScore createBlastScore(Row row) {
        BlastScore blastScore = new BlastScore();
        blastScore.setScore(row.score);
        blastScore.setBitScore(row.bitscore);
        blastScore.setEvalue(row.evalue);
        return blastScore;
    }

    private static final class Row {
        private String title;
        private double bitscore;
        private double score;
        private double evalue;
        private int sstart;
        private int send;
        private int qstart;
        private int qend;
        private int len;
        private int numberOfMismatchs;
        private int totalNumberOfGaps;

        Row(String line) {
            String[] cells = line.split("\t");
            this.title = cells[this.len++];
            this.bitscore = this.asDouble(cells);
            this.score = this.asDouble(cells);
            this.evalue = this.asDouble(cells);
            this.sstart = this.asInt(cells);
            this.send = this.asInt(cells);
            this.qstart = this.asInt(cells);
            this.qend = this.asInt(cells);
            this.numberOfMismatchs = this.asInt(cells);
            this.totalNumberOfGaps = this.asInt(cells);
        }

        private int asInt(String[] cells) {
            try {
                return Integer.parseInt(cells[this.len++]);
            }
            catch (RuntimeException ex) {
                return -1;
            }
        }

        private double asDouble(String[] cells) {
            try {
                return Double.parseDouble(cells[this.len++]);
            }
            catch (RuntimeException ex) {
                return 0.0;
            }
        }
    }
}

