/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.server.api.v2.sequencedatabases;

import ch.systemsx.cisd.base.exceptions.CheckedExceptionTunnel;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.properties.PropertyUtils;
import ch.systemsx.cisd.openbis.dss.generic.server.api.v2.sequencedatabases.AbstractSearchDomainService;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.AlignmentMatch;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.DataSetFileBlastSearchResultLocation;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.EntityKind;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.EntityPropertySearchResultLocation;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.ISearchDomainResultLocation;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.SearchDomain;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.SearchDomainSearchOption;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.SearchDomainSearchResult;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Logger;

public class EchoDatabase
extends AbstractSearchDomainService {
    public static final Logger operationLog = LogFactory.getLogger((LogCategory)LogCategory.OPERATION, EchoDatabase.class);
    private boolean available;
    private List<SearchDomainSearchOption> searchOptions = new ArrayList<SearchDomainSearchOption>();

    public EchoDatabase(Properties properties, File storeRoot) {
        super(properties, storeRoot);
        this.available = PropertyUtils.getBoolean((Properties)properties, (String)"available", (boolean)true);
        List optionCodes = PropertyUtils.getList((Properties)properties, (String)"possible-search-options");
        for (String optionCode : optionCodes) {
            SearchDomainSearchOption option = new SearchDomainSearchOption();
            option.setCode(optionCode);
            option.setLabel(properties.getProperty(optionCode + ".label", optionCode));
            option.setDescription(properties.getProperty(optionCode + ".description", ""));
            this.searchOptions.add(option);
        }
    }

    @Override
    public boolean isAvailable() {
        return this.available;
    }

    @Override
    public String getPossibleSearchOptionsKey() {
        return this.searchOptions.isEmpty() ? null : "optionsKey";
    }

    @Override
    public List<SearchDomainSearchOption> getPossibleSearchOptions() {
        return this.searchOptions;
    }

    @Override
    public List<SearchDomainSearchResult> search(String sequenceSnippet, Map<String, String> optionalParametersOrNull) {
        String resultStr = optionalParametersOrNull.get(sequenceSnippet);
        if (resultStr != null) {
            try {
                ObjectMapper mapper = new ObjectMapper();
                HelperBean bean = (HelperBean)mapper.readValue(resultStr, HelperBean.class);
                ISearchDomainResultLocation resultLocation = bean.getResultLocation();
                SearchDomainSearchResult result = new SearchDomainSearchResult();
                result.setSearchDomain(bean.getSearchDomain());
                result.setResultLocation(resultLocation);
                return Collections.singletonList(result);
            }
            catch (Exception e) {
                operationLog.error((Object)"Couldn't create result", (Throwable)e);
                throw CheckedExceptionTunnel.wrapIfNecessary((Exception)e);
            }
        }
        return Collections.emptyList();
    }

    public static final class HelperBean {
        private SearchDomain searchDomain = new SearchDomain();
        private DataSetFileBlastSearchResultLocation dataSetFileBlastResultLocation;
        private EntityPropertySearchResultLocation entityPropertyResultLocation;

        public ISearchDomainResultLocation getResultLocation() {
            return this.dataSetFileBlastResultLocation == null ? this.entityPropertyResultLocation : this.dataSetFileBlastResultLocation;
        }

        public SearchDomain getSearchDomain() {
            return this.searchDomain;
        }

        public void setSearchDomain(String searchDomain) {
            this.searchDomain.setName(searchDomain);
        }

        public void setDataSetCode(String dataSetCode) {
            this.getDataSetFileBlastResultLocation().setCode(dataSetCode);
            this.getDataSetFileBlastResultLocation().setPermId(dataSetCode);
        }

        public void setPathInDataSet(String path) {
            this.getDataSetFileBlastResultLocation().setPathInDataSet(path);
        }

        public void setSequenceIdentifier(String identifier) {
            this.getDataSetFileBlastResultLocation().setIdentifier(identifier);
        }

        public void setPositionInSequence(int position) {
            this.getDataSetFileBlastResultLocation().setPosition(position);
        }

        public void setAlignmentMatchSequenceStart(int pos) {
            this.getAlignmentMatch().setSequenceStart(pos);
        }

        public void setAlignmentMatchSequenceEnd(int pos) {
            this.getAlignmentMatch().setSequenceEnd(pos);
        }

        public void setAlignmentMatchQueryStart(int pos) {
            this.getAlignmentMatch().setQueryStart(pos);
        }

        public void setAlignmentMatchQueryEnd(int pos) {
            this.getAlignmentMatch().setQueryEnd(pos);
        }

        public void setAlignmentMatchMismatches(int n) {
            this.getAlignmentMatch().setNumberOfMismatches(n);
        }

        public void setAlignmentMatchGaps(int n) {
            this.getAlignmentMatch().setTotalNumberOfGaps(n);
        }

        public void setEntityKind(EntityKind entityKind) {
            this.getEntityPropertyResultLocation().setEntityKind(entityKind);
        }

        public void setEntityType(String entityType) {
            this.getEntityPropertyResultLocation().setEntityType(entityType);
        }

        public void setPermId(String permId) {
            this.getEntityPropertyResultLocation().setPermId(permId);
        }

        public void setCode(String code) {
            this.getEntityPropertyResultLocation().setCode(code);
        }

        public void setPropertyType(String propertyType) {
            this.getEntityPropertyResultLocation().setPropertyType(propertyType);
        }

        private DataSetFileBlastSearchResultLocation getDataSetFileBlastResultLocation() {
            if (this.dataSetFileBlastResultLocation == null) {
                this.dataSetFileBlastResultLocation = new DataSetFileBlastSearchResultLocation();
            }
            return this.dataSetFileBlastResultLocation;
        }

        private AlignmentMatch getAlignmentMatch() {
            AlignmentMatch alignmentMatch = this.getDataSetFileBlastResultLocation().getAlignmentMatch();
            if (alignmentMatch == null) {
                alignmentMatch = new AlignmentMatch();
                this.getDataSetFileBlastResultLocation().setAlignmentMatch(alignmentMatch);
            }
            return alignmentMatch;
        }

        private EntityPropertySearchResultLocation getEntityPropertyResultLocation() {
            if (this.entityPropertyResultLocation == null) {
                this.entityPropertyResultLocation = new EntityPropertySearchResultLocation();
            }
            return this.entityPropertyResultLocation;
        }
    }
}

