/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.server.dbbackup;

import ch.systemsx.cisd.common.properties.ExtendedProperties;
import ch.systemsx.cisd.common.properties.PropertyParametersUtil;
import ch.systemsx.cisd.common.reflection.BeanUtils;
import ch.systemsx.cisd.dbmigration.DatabaseConfigurationContext;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public class BackupDatabaseParser {
    private static final String OWNER = "owner";
    private static final String OWNER_PASSWORD = "owner-password";
    private static final String URL_HOST_PART = "url-host-part";
    private static final String DB_KIND = "kind";
    private static final String EMPTY = "";

    public static String getAppServerDatabaseDescription(Properties properties, String dbKeyPrefix, String basicDatabaseName) {
        ExtendedProperties dbProps = ExtendedProperties.getSubset((Properties)properties, (String)dbKeyPrefix, (boolean)true);
        if (dbProps.isEmpty()) {
            return EMPTY;
        }
        DatabaseConfigurationContext context = new DatabaseConfigurationContext();
        context.setBasicDatabaseName(basicDatabaseName);
        context.setDatabaseKind(dbProps.getProperty(DB_KIND, "dev"));
        context.setUrlHostPart(dbProps.getProperty(URL_HOST_PART, EMPTY));
        context.setOwner(dbProps.getProperty(OWNER, EMPTY));
        context.setPassword(dbProps.getProperty(OWNER_PASSWORD, EMPTY));
        return BackupDatabaseParser.createReturnValue(context);
    }

    public static List<String> getDssServerDatabaseDescriptions(Properties properties) {
        PropertyParametersUtil.SectionProperties[] sectionProps;
        ArrayList<String> descriptions = new ArrayList<String>();
        for (PropertyParametersUtil.SectionProperties dataSourceProperties : sectionProps = PropertyParametersUtil.extractSectionProperties((Properties)properties, (String)"data-sources", (boolean)false)) {
            Properties dbProps = dataSourceProperties.getProperties();
            String versionHolderClass = dbProps.getProperty("version-holder-class");
            if (versionHolderClass == null) continue;
            DatabaseConfigurationContext dbContext = (DatabaseConfigurationContext)BeanUtils.createBean(DatabaseConfigurationContext.class, (Object)dbProps);
            descriptions.add(BackupDatabaseParser.createReturnValue(dbContext));
        }
        return descriptions;
    }

    private static String createReturnValue(DatabaseConfigurationContext context) {
        String host = context.getUrlHostPart();
        String database = context.getDatabaseName();
        String username = context.getOwner();
        String password = context.getPassword();
        String templateWithOutHost = "database=%s;username=%s;password=%s";
        if (host == null || host.length() == 0) {
            return String.format(templateWithOutHost, database, username, password);
        }
        return String.format(templateWithOutHost + ";host=%s", database, username, password, host);
    }
}

