/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.server.fs;

import ch.systemsx.cisd.base.exceptions.CheckedExceptionTunnel;
import ch.systemsx.cisd.base.io.IRandomAccessFile;
import ch.systemsx.cisd.common.exceptions.ConfigurationFailureException;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.openbis.common.io.hierarchical_content.HierarchicalContentUtils;
import ch.systemsx.cisd.openbis.common.io.hierarchical_content.api.IHierarchicalContent;
import ch.systemsx.cisd.openbis.common.io.hierarchical_content.api.IHierarchicalContentNode;
import ch.systemsx.cisd.openbis.dss.generic.server.fs.api.IResolverPlugin;
import ch.systemsx.cisd.openbis.dss.generic.server.fs.api.file.IFileSystemViewResponse;
import ch.systemsx.cisd.openbis.dss.generic.server.fs.file.DirectoryResponse;
import ch.systemsx.cisd.openbis.dss.generic.server.fs.file.FileResponse;
import ch.systemsx.cisd.openbis.dss.generic.server.fs.file.NonExistingFileResponse;
import ch.systemsx.cisd.openbis.dss.generic.server.fs.plugins.FileSystemPlugin;
import ch.systemsx.cisd.openbis.dss.generic.server.fs.resolver.RootLevelResolver;
import ch.systemsx.cisd.openbis.dss.generic.server.ftp.Cache;
import ch.systemsx.cisd.openbis.dss.generic.server.ftp.FtpPathResolverConfig;
import ch.systemsx.cisd.openbis.dss.generic.server.ftp.FtpPathResolverContext;
import ch.systemsx.cisd.openbis.dss.generic.server.ftp.IFtpPathResolverRegistry;
import ch.systemsx.cisd.openbis.dss.generic.server.ftp.NonExistingFtpFile;
import ch.systemsx.cisd.openbis.dss.generic.server.ftp.resolver.AbstractFtpFile;
import ch.systemsx.cisd.openbis.dss.generic.server.ftp.resolver.AbstractFtpFileWithContent;
import ch.systemsx.cisd.openbis.dss.generic.server.ftp.resolver.AbstractFtpFolder;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.FileChannel;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import org.apache.ftpserver.ftplet.FtpFile;
import org.apache.log4j.Logger;

public class FtpPathResolverRegistry
implements IFtpPathResolverRegistry {
    private static final Logger operationLog = LogFactory.getLogger((LogCategory)LogCategory.OPERATION, FtpPathResolverRegistry.class);
    private List<FileSystemPlugin> plugins = new LinkedList<FileSystemPlugin>();

    private static String concatenatePathElements(String parent, String child) {
        String normalizedParent = parent.endsWith("/") ? parent : parent + "/";
        String normalizedChild = child.startsWith("/") ? child.substring(1) : child;
        return normalizedParent + normalizedChild;
    }

    @Override
    public void initialize(FtpPathResolverConfig config) {
        Properties props = config.getProperties();
        String listOfEnabledFileSystemPlugins = props.getProperty("file-system-plugins");
        if (listOfEnabledFileSystemPlugins != null) {
            String[] split;
            for (String pluginName : split = listOfEnabledFileSystemPlugins.split(",")) {
                pluginName = pluginName.trim();
                String className = props.getProperty(pluginName + ".resolver-class");
                String code = props.getProperty(pluginName + ".code");
                try {
                    Class<?> clazz = Class.forName(className);
                    this.plugins.add(new FileSystemPlugin(pluginName, code, clazz));
                }
                catch (ClassNotFoundException ex) {
                    throw new ConfigurationFailureException("Couldn't load class for file system plugin: " + className);
                }
                catch (SecurityException ex) {
                    throw new ConfigurationFailureException("Couldn't load class for file system plugin");
                }
                catch (Exception ex) {
                    throw new ConfigurationFailureException("Couldn't load class for file system plugin", (Throwable)ex);
                }
            }
        }
    }

    private FtpFile convert(IFileSystemViewResponse response, FtpPathResolverContext resolverContext) {
        if (response instanceof DirectoryResponse) {
            return this.convert((DirectoryResponse)response, resolverContext);
        }
        if (response instanceof FileResponse) {
            return this.convert((FileResponse)response);
        }
        if (response instanceof NonExistingFileResponse) {
            return this.convert((NonExistingFileResponse)response);
        }
        throw new IllegalArgumentException("Unknown object of type " + IFileSystemViewResponse.class.getName());
    }

    private FtpFile convert(final DirectoryResponse dir, final FtpPathResolverContext resolverContext) {
        AbstractFtpFolder abstractFtpFolder = new AbstractFtpFolder(dir.getFullPath()){

            @Override
            public List<FtpFile> unsafeListFiles() throws RuntimeException {
                LinkedList<FtpFile> result = new LinkedList<FtpFile>();
                for (DirectoryResponse.Node entry : dir.getFiles()) {
                    AbstractFtpFile file = null;
                    if (entry instanceof DirectoryResponse.DirectoryNode) {
                        file = new NodeBasedFtpFolder(this.absolutePath, entry, FtpPathResolverRegistry.this, resolverContext);
                    } else if (entry instanceof DirectoryResponse.FileNode) {
                        file = new NodeBasedFtpFile((DirectoryResponse.FileNode)entry, FtpPathResolverRegistry.this, resolverContext);
                    }
                    if (file == null) continue;
                    file.setLastModified(entry.getLastModified());
                    String key = FtpPathResolverRegistry.this.createKey(file.getAbsolutePath(), resolverContext);
                    resolverContext.getCache().putResponse(key, file);
                    result.add(file);
                }
                return result;
            }
        };
        String key = this.createKey(abstractFtpFolder.getAbsolutePath(), resolverContext);
        FtpFile response = resolverContext.getCache().getResponse(key);
        if (response != null) {
            abstractFtpFolder.setLastModified(response.getLastModified());
        }
        return abstractFtpFolder;
    }

    private FtpFile convert(final FileResponse file) {
        AbstractFtpFileWithContent fileWithContent = new AbstractFtpFileWithContent(file.getFullPath()){

            public InputStream createInputStream(long offset) throws IOException {
                IHierarchicalContent content = file.getContent();
                try {
                    IHierarchicalContentNode node = file.getNode();
                    InputStream result = HierarchicalContentUtils.getInputStreamAutoClosingContent((IHierarchicalContentNode)node, (IHierarchicalContent)content);
                    if (offset > 0L) {
                        result.skip(offset);
                    }
                    return result;
                }
                catch (IOException ioex) {
                    content.close();
                    operationLog.error((Object)("Error while reading content at " + offset + " from " + this.absolutePath), (Throwable)ioex);
                    throw ioex;
                }
                catch (RuntimeException re) {
                    content.close();
                    operationLog.error((Object)("Error while reading content at " + offset + " from " + this.absolutePath), (Throwable)re);
                    throw re;
                }
            }

            @Override
            public FileChannel getFileChannel() {
                File f = file.getNode().tryGetFile();
                if (f == null) {
                    throw new UnsupportedOperationException("Only real files are supported.");
                }
                Path path = f.toPath();
                EnumSet<StandardOpenOption> options = EnumSet.of(StandardOpenOption.READ);
                try {
                    return path.getFileSystem().provider().newFileChannel(path, options, new FileAttribute[0]);
                }
                catch (IOException e) {
                    throw CheckedExceptionTunnel.wrapIfNecessary((Exception)e);
                }
            }

            public boolean isFile() {
                return true;
            }

            public boolean isDirectory() {
                return false;
            }

            @Override
            public List<FtpFile> unsafeListFiles() throws RuntimeException {
                throw new IllegalStateException("Don't expect to ask for file listing of file");
            }

            @Override
            public IRandomAccessFile getFileContent() {
                return file.getNode().getFileContent();
            }
        };
        fileWithContent.setLastModified(file.getNode().getLastModified());
        fileWithContent.setSize(file.getNode().getFileLength());
        return fileWithContent;
    }

    private FtpFile convert(NonExistingFileResponse nonExistingFile) {
        return new NonExistingFtpFile(nonExistingFile.getFullPath(), nonExistingFile.getErrorMsg());
    }

    @Override
    public FtpFile resolve(String path, FtpPathResolverContext resolverContext) {
        String responseCacheKey = this.createKey(path, resolverContext);
        Cache cache = resolverContext.getCache();
        FtpFile response = cache.getResponse(responseCacheKey);
        if (response != null) {
            operationLog.info((Object)("Path " + path + " requested (found in cache)."));
            return response;
        }
        response = this.resolveAndConvert(path, resolverContext);
        cache.putResponse(responseCacheKey, response);
        operationLog.info((Object)("Path " + path + " requested."));
        return response;
    }

    private FtpFile resolveAndConvert(String path, FtpPathResolverContext resolverContext) {
        IFileSystemViewResponse response;
        String[] split = path.equals("/") ? new String[]{} : path.substring(1).split("/");
        try {
            response = this.plugins.size() > 0 ? this.resolvePlugins(path, split, resolverContext) : this.resolveDefault(path, resolverContext, split);
        }
        catch (Exception e) {
            operationLog.warn((Object)("Resolving " + path + " failed"), (Throwable)e);
            response = resolverContext.getResolverContext().createNonExistingFileResponse("Error when retrieving path");
        }
        return this.convert(response, resolverContext);
    }

    private String createKey(String path, FtpPathResolverContext resolverContext) {
        return resolverContext.getSessionToken() + "$" + path;
    }

    private IFileSystemViewResponse resolveDefault(String path, FtpPathResolverContext resolverContext, String[] split) {
        RootLevelResolver resolver = new RootLevelResolver();
        return resolver.resolve(split, resolverContext.getResolverContext());
    }

    private IFileSystemViewResponse resolvePlugins(String path, String[] subPath, FtpPathResolverContext resolverContext) {
        if (subPath.length == 0) {
            DirectoryResponse response = resolverContext.getResolverContext().createDirectoryResponse();
            response.addDirectory("DEFAULT");
            for (FileSystemPlugin plugin : this.plugins) {
                response.addDirectory(plugin.getPluginCode());
            }
            return response;
        }
        String[] remaining = Arrays.copyOfRange(subPath, 1, subPath.length);
        if (subPath[0].equals("DEFAULT")) {
            return this.resolveDefault(path, resolverContext, remaining);
        }
        for (FileSystemPlugin plugin : this.plugins) {
            if (!plugin.getPluginCode().equals(subPath[0])) continue;
            IResolverPlugin resolver = plugin.getPluginResolver();
            return resolver.resolve(remaining, resolverContext.getResolverContext());
        }
        return resolverContext.getResolverContext().createNonExistingFileResponse(null);
    }

    private static final class NodeBasedFtpFolder
    extends AbstractFtpFolder {
        private FtpPathResolverRegistry ftpPathResolverRegistry;
        private FtpPathResolverContext resolverContext;

        NodeBasedFtpFolder(String parentAbsolutePath, DirectoryResponse.Node node, FtpPathResolverRegistry ftpPathResolverRegistry, FtpPathResolverContext resolverContext) {
            super(FtpPathResolverRegistry.concatenatePathElements(parentAbsolutePath, node.getFullPath()));
            this.ftpPathResolverRegistry = ftpPathResolverRegistry;
            this.resolverContext = resolverContext.cloneForPath(this.getAbsolutePath());
        }

        @Override
        public List<FtpFile> unsafeListFiles() throws RuntimeException {
            FtpFile ftpFile = this.ftpPathResolverRegistry.resolveAndConvert(this.absolutePath, this.resolverContext);
            return ftpFile.listFiles();
        }
    }

    private static final class NodeBasedFtpFile
    extends AbstractFtpFileWithContent {
        private final FtpPathResolverRegistry ftpPathResolverRegistry;
        private final FtpPathResolverContext resolverContext;

        NodeBasedFtpFile(DirectoryResponse.FileNode fileNode, FtpPathResolverRegistry ftpPathResolverRegistry, FtpPathResolverContext resolverContext) {
            super(fileNode.getFullPath());
            this.setSize(fileNode.getSize());
            this.ftpPathResolverRegistry = ftpPathResolverRegistry;
            this.resolverContext = resolverContext.cloneForPath(this.getAbsolutePath());
        }

        public boolean isFile() {
            return true;
        }

        public boolean isDirectory() {
            return false;
        }

        public InputStream createInputStream(long offset) throws IOException {
            FtpFile ftpFile = this.ftpPathResolverRegistry.resolveAndConvert(this.absolutePath, this.resolverContext);
            return ftpFile.createInputStream(offset);
        }

        @Override
        public List<FtpFile> unsafeListFiles() throws RuntimeException {
            throw new UnsupportedOperationException("Listing files not supported: " + this.absolutePath);
        }

        @Override
        public IRandomAccessFile getFileContent() {
            FtpFile ftpFile = this.ftpPathResolverRegistry.resolveAndConvert(this.absolutePath, this.resolverContext);
            if (ftpFile instanceof AbstractFtpFileWithContent) {
                AbstractFtpFileWithContent fileWithContent = (AbstractFtpFileWithContent)ftpFile;
                return fileWithContent.getFileContent();
            }
            throw new UnsupportedOperationException("Content not supported: " + this.absolutePath);
        }

        @Override
        public FileChannel getFileChannel() throws IOException {
            FtpFile file = this.ftpPathResolverRegistry.resolveAndConvert(this.absolutePath, this.resolverContext);
            NonExistingFtpFile.throwFileNotFoundExceptionIfNonExistingFtpFile(file);
            if (file instanceof AbstractFtpFileWithContent) {
                return ((AbstractFtpFileWithContent)file).getFileChannel();
            }
            return super.getFileChannel();
        }
    }
}

