/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.server.fs;

import ch.ethz.sis.openbis.generic.asapi.v3.IApplicationServerApi;
import ch.systemsx.cisd.common.server.ISessionTokenProvider;
import ch.systemsx.cisd.openbis.common.io.hierarchical_content.api.IHierarchicalContent;
import ch.systemsx.cisd.openbis.common.io.hierarchical_content.api.IHierarchicalContentNode;
import ch.systemsx.cisd.openbis.dss.generic.server.fs.api.IResolverContext;
import ch.systemsx.cisd.openbis.dss.generic.server.fs.file.DirectoryResponse;
import ch.systemsx.cisd.openbis.dss.generic.server.fs.file.FileResponse;
import ch.systemsx.cisd.openbis.dss.generic.server.fs.file.NonExistingFileResponse;
import ch.systemsx.cisd.openbis.dss.generic.server.ftp.Cache;
import ch.systemsx.cisd.openbis.dss.generic.shared.IHierarchicalContentProvider;
import ch.systemsx.cisd.openbis.dss.generic.shared.ServiceProvider;

public class ResolverContext
implements ISessionTokenProvider,
IResolverContext {
    private final String sessionToken;
    private final Cache cache;
    private final IApplicationServerApi api;
    private IHierarchicalContentProvider contentProvider;
    private final String fullPath;

    public ResolverContext(String sessionToken, Cache cache, IApplicationServerApi api, String fullPath) {
        this.sessionToken = sessionToken;
        this.cache = cache;
        this.api = api;
        this.fullPath = fullPath;
    }

    @Override
    public FileResponse createFileResponse(IHierarchicalContentNode node, IHierarchicalContent content) {
        if (node.isDirectory()) {
            throw new IllegalArgumentException("Only file nodes can be used to create file response.");
        }
        return new FileResponse(this.fullPath, node, content);
    }

    @Override
    public DirectoryResponse createDirectoryResponse() {
        return new DirectoryResponse(this.fullPath);
    }

    @Override
    public NonExistingFileResponse createNonExistingFileResponse(String errorMsg) {
        return new NonExistingFileResponse(this.fullPath, errorMsg);
    }

    @Override
    public String getSessionToken() {
        return this.sessionToken;
    }

    @Override
    public IHierarchicalContentProvider getContentProvider() {
        if (this.contentProvider == null) {
            this.contentProvider = ServiceProvider.getHierarchicalContentProvider();
        }
        return this.contentProvider.cloneFor(this);
    }

    @Override
    public IApplicationServerApi getApi() {
        return this.api;
    }

    public Cache getCache() {
        return this.cache;
    }
}

