/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.server.fs.file;

import ch.systemsx.cisd.openbis.common.io.hierarchical_content.api.IHierarchicalContentNode;
import ch.systemsx.cisd.openbis.dss.generic.server.fs.api.file.IDirectoryResponse;
import ch.systemsx.cisd.openbis.dss.generic.shared.ServiceProvider;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class DirectoryResponse
implements IDirectoryResponse {
    private final List<Node> files;
    private final String fullPath;

    public DirectoryResponse(String fullPath) {
        this.fullPath = fullPath;
        this.files = new ArrayList<Node>();
    }

    public List<Node> getFiles() {
        return this.files;
    }

    public String getFullPath() {
        return this.fullPath;
    }

    @Override
    public void addDirectory(String directoryName) {
        this.addDirectory(directoryName, ServiceProvider.DSS_STARTUP_DATE);
    }

    @Override
    public void addDirectory(String directoryName, Date lastModified) {
        this.addDirectory(directoryName, lastModified.getTime());
    }

    @Override
    public void addDirectory(String directoryName, long lastModified) {
        this.files.add(new DirectoryNode(directoryName, lastModified));
    }

    @Override
    public void addFile(String fileName, IHierarchicalContentNode node) {
        this.addFile(fileName, node.getFileLength(), node.getLastModified());
    }

    @Override
    public void addFile(String fileName, long size, long lastModified) {
        this.files.add(new FileNode(this.fullPath + "/" + fileName, size, lastModified));
    }

    public static class FileNode
    implements Node {
        final String fullPath;
        final long size;
        final long lastModified;

        private FileNode(String fullPath, long size, long lastModified) {
            this.fullPath = fullPath;
            this.size = size;
            this.lastModified = lastModified;
        }

        @Override
        public String getFullPath() {
            return this.fullPath;
        }

        public long getSize() {
            return this.size;
        }

        @Override
        public long getLastModified() {
            return this.lastModified;
        }
    }

    public static class DirectoryNode
    implements Node {
        final String fullPath;
        final long lastModified;

        private DirectoryNode(String fullPath, long lastModified) {
            this.fullPath = fullPath;
            this.lastModified = lastModified;
        }

        @Override
        public String getFullPath() {
            return this.fullPath;
        }

        @Override
        public long getLastModified() {
            return this.lastModified;
        }
    }

    public static interface Node {
        public String getFullPath();

        public long getLastModified();
    }
}

