/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.server.fs.plugins;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.dataset.DataSet;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.dataset.DataSetType;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.dataset.fetchoptions.DataSetFetchOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.dataset.fetchoptions.DataSetTypeFetchOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.dataset.id.DataSetPermId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.dataset.search.DataSetSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.dataset.search.DataSetTypeSearchCriteria;
import ch.systemsx.cisd.openbis.common.io.hierarchical_content.api.IHierarchicalContent;
import ch.systemsx.cisd.openbis.common.io.hierarchical_content.api.IHierarchicalContentNode;
import ch.systemsx.cisd.openbis.dss.generic.server.fs.api.IResolverContext;
import ch.systemsx.cisd.openbis.dss.generic.server.fs.api.IResolverPlugin;
import ch.systemsx.cisd.openbis.dss.generic.server.fs.api.file.IDirectoryResponse;
import ch.systemsx.cisd.openbis.dss.generic.server.fs.api.file.IFileSystemViewResponse;
import ch.systemsx.cisd.openbis.dss.generic.shared.IHierarchicalContentProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Stack;

public class DataSetTypeResolver
implements IResolverPlugin {
    @Override
    public IFileSystemViewResponse resolve(String[] subPath, IResolverContext context) {
        if (subPath.length == 0) {
            return this.listDataSetTypes(context);
        }
        String dataSetType = subPath[0];
        if (subPath.length == 1) {
            return this.listDataSetsOfGivenType(dataSetType, context);
        }
        return this.resolveFileSearch(subPath, context);
    }

    private IFileSystemViewResponse resolveFileSearch(String[] subPath, IResolverContext context) {
        String requestedFileName;
        String dataSetCode = subPath[1];
        String string = requestedFileName = subPath.length == 2 ? null : subPath[2];
        if (subPath.length > 3) {
            throw new IllegalArgumentException("This resolver can't resolve path of that length");
        }
        List<DataSet> dataSetsToSearch = this.searchForDataSetAndParents(dataSetCode, context);
        if (dataSetsToSearch == null) {
            return context.createNonExistingFileResponse(null);
        }
        if (requestedFileName != null) {
            IFileSystemViewResponse result = this.findRequestedNode(dataSetsToSearch, requestedFileName, context);
            if (result != null) {
                return result;
            }
            return context.createNonExistingFileResponse("Unable to locate requested file");
        }
        IDirectoryResponse response = context.createDirectoryResponse();
        for (IHierarchicalContentNode file : this.findAllNodes(dataSetsToSearch, context.getContentProvider())) {
            response.addFile(file.getName(), file);
        }
        return response;
    }

    private List<IHierarchicalContentNode> findAllNodes(List<DataSet> dataSetsToSearch, IHierarchicalContentProvider contentProvider) {
        ArrayList<IHierarchicalContentNode> result = new ArrayList<IHierarchicalContentNode>();
        for (DataSet dataSet : dataSetsToSearch) {
            Stack<IHierarchicalContentNode> nodes = new Stack<IHierarchicalContentNode>();
            nodes.push(contentProvider.asContent(dataSet.getCode()).getRootNode());
            while (!nodes.isEmpty()) {
                IHierarchicalContentNode node = (IHierarchicalContentNode)nodes.pop();
                if (node.isDirectory()) {
                    for (IHierarchicalContentNode child : node.getChildNodes()) {
                        nodes.push(child);
                    }
                    continue;
                }
                result.add(node);
            }
        }
        return result;
    }

    private IFileSystemViewResponse findRequestedNode(List<DataSet> dataSetsToSearch, String requestedFileName, IResolverContext context) {
        IHierarchicalContentProvider contentProvider = context.getContentProvider();
        for (DataSet dataSet : dataSetsToSearch) {
            IHierarchicalContent content = contentProvider.asContent(dataSet.getCode());
            IHierarchicalContentNode node = this.findRequestedNode(content.getRootNode(), requestedFileName);
            if (node == null) continue;
            return context.createFileResponse(node, content);
        }
        return null;
    }

    private IHierarchicalContentNode findRequestedNode(IHierarchicalContentNode node, String requestedFileName) {
        if (node.isDirectory()) {
            for (IHierarchicalContentNode subNode : node.getChildNodes()) {
                IHierarchicalContentNode result = this.findRequestedNode(subNode, requestedFileName);
                if (result == null) continue;
                return result;
            }
        } else if (node.getName().equals(requestedFileName)) {
            return node;
        }
        return null;
    }

    private List<DataSet> searchForDataSetAndParents(String dataSetCode, IResolverContext context) {
        DataSetPermId dataId = new DataSetPermId(dataSetCode);
        DataSetFetchOptions fetchOptions = new DataSetFetchOptions();
        fetchOptions.withParents();
        DataSet dataSet = (DataSet)context.getApi().getDataSets(context.getSessionToken(), Collections.singletonList(dataId), fetchOptions).get(dataId);
        if (dataSet == null) {
            return null;
        }
        ArrayList<DataSet> dataSetsToSearch = new ArrayList<DataSet>();
        dataSetsToSearch.add(dataSet);
        dataSetsToSearch.addAll(dataSet.getParents());
        return dataSetsToSearch;
    }

    private IFileSystemViewResponse listDataSetsOfGivenType(String dataSetType, IResolverContext context) {
        DataSetFetchOptions fetchOptions = new DataSetFetchOptions();
        fetchOptions.withParents();
        DataSetSearchCriteria searchCriteria = new DataSetSearchCriteria();
        searchCriteria.withType().withCode().thatEquals(dataSetType);
        List dataSets = context.getApi().searchDataSets(context.getSessionToken(), searchCriteria, fetchOptions).getObjects();
        IDirectoryResponse result = context.createDirectoryResponse();
        for (DataSet dataSet : dataSets) {
            result.addDirectory(dataSet.getCode(), dataSet.getModificationDate());
        }
        return result;
    }

    private IFileSystemViewResponse listDataSetTypes(IResolverContext context) {
        List dataSetTypes = context.getApi().searchDataSetTypes(context.getSessionToken(), new DataSetTypeSearchCriteria(), new DataSetTypeFetchOptions()).getObjects();
        IDirectoryResponse response = context.createDirectoryResponse();
        for (DataSetType type : dataSetTypes) {
            response.addDirectory(type.getCode());
        }
        return response;
    }

    @Override
    public void initialize(String name, String code) {
    }
}

