/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.server.fs.plugins;

import ch.systemsx.cisd.common.jython.JythonUtils;
import ch.systemsx.cisd.common.jython.evaluator.Evaluator;
import ch.systemsx.cisd.common.jython.evaluator.IJythonEvaluator;
import ch.systemsx.cisd.common.properties.PropertyUtils;
import ch.systemsx.cisd.openbis.dss.generic.server.fs.api.IResolverContext;
import ch.systemsx.cisd.openbis.dss.generic.server.fs.api.IResolverPlugin;
import ch.systemsx.cisd.openbis.dss.generic.server.fs.api.file.IFileSystemViewResponse;
import ch.systemsx.cisd.openbis.dss.generic.shared.utils.DssPropertyParametersUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class JythonResolver
implements IResolverPlugin {
    private static Map<String, IJythonEvaluator> interpreters = new HashMap<String, IJythonEvaluator>();
    private static final String RESOLVE_FUNCTION_NAME = "resolve";
    private static final String SCRIPT_FILENAME_PROPERTY = "script-file";
    private IJythonEvaluator interpreter;

    @Override
    public IFileSystemViewResponse resolve(String[] pathItems, IResolverContext resolverContext) {
        Object result = this.interpreter.evalFunction(RESOLVE_FUNCTION_NAME, new Object[]{pathItems, resolverContext});
        return (IFileSystemViewResponse)result;
    }

    @Override
    public void initialize(String pluginName, String code) {
        if (!interpreters.containsKey(pluginName)) {
            String scriptPath = PropertyUtils.getMandatoryProperty((Properties)DssPropertyParametersUtil.loadServiceProperties(), (String)(pluginName + "." + SCRIPT_FILENAME_PROPERTY));
            String scriptString = JythonUtils.extractScriptFromPath((String)scriptPath);
            String[] pythonPath = JythonUtils.getScriptDirectoryPythonPath((String[])new String[]{scriptPath});
            interpreters.put(pluginName, Evaluator.getFactory().create("", pythonPath, scriptPath, null, scriptString, false));
        }
        this.interpreter = interpreters.get(pluginName);
    }
}

