/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.server.fs.plugins;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.dataset.DataSet;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.dataset.fetchoptions.DataSetFetchOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.dataset.search.DataSetSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.sample.Sample;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.sample.SampleType;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.sample.fetchoptions.SampleFetchOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.sample.fetchoptions.SampleTypeFetchOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.sample.search.SampleSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.sample.search.SampleTypeSearchCriteria;
import ch.systemsx.cisd.openbis.dss.generic.server.fs.api.IResolverContext;
import ch.systemsx.cisd.openbis.dss.generic.server.fs.api.IResolverPlugin;
import ch.systemsx.cisd.openbis.dss.generic.server.fs.api.file.IDirectoryResponse;
import ch.systemsx.cisd.openbis.dss.generic.server.fs.api.file.IFileSystemViewResponse;
import ch.systemsx.cisd.openbis.dss.generic.server.fs.resolver.DataSetContentResolver;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;

public class SampleTypeResolver
implements IResolverPlugin {
    @Override
    public IFileSystemViewResponse resolve(String[] subPath, IResolverContext context) {
        if (subPath.length == 0) {
            return this.listSampleTypes(context);
        }
        String sampleType = subPath[0];
        if (subPath.length == 1) {
            return this.listSamplesOfGivenType(sampleType, context);
        }
        String sampleCode = subPath[1];
        if (subPath.length == 2) {
            return this.listDataSetsForGivenSampleTypeAndCode(sampleType, sampleCode, context);
        }
        String dataSetCode = subPath[2];
        String[] remaining = Arrays.copyOfRange(subPath, 3, subPath.length);
        return new DataSetContentResolver(dataSetCode).resolve(remaining, context);
    }

    private IFileSystemViewResponse listDataSetsForGivenSampleTypeAndCode(String sampleTypeCode, String sampleCode, IResolverContext context) {
        DataSetSearchCriteria searchCriteria = new DataSetSearchCriteria();
        searchCriteria.withSample().withType().withCode().thatEquals(sampleTypeCode);
        searchCriteria.withSample().withCode().thatEquals(sampleCode);
        List dataSets = context.getApi().searchDataSets(context.getSessionToken(), searchCriteria, new DataSetFetchOptions()).getObjects();
        IDirectoryResponse result = context.createDirectoryResponse();
        for (DataSet dataSet : dataSets) {
            result.addDirectory(dataSet.getCode(), dataSet.getModificationDate());
        }
        return result;
    }

    private IFileSystemViewResponse listSamplesOfGivenType(String sampleType, IResolverContext context) {
        SampleSearchCriteria searchCriteria = new SampleSearchCriteria();
        searchCriteria.withType().withCode().thatEquals(sampleType);
        List samples = context.getApi().searchSamples(context.getSessionToken(), searchCriteria, new SampleFetchOptions()).getObjects();
        HashSet<String> sampleCodes = new HashSet<String>();
        IDirectoryResponse result = context.createDirectoryResponse();
        for (Sample sample : samples) {
            if (sampleCodes.contains(sample.getCode())) continue;
            result.addDirectory(sample.getCode(), sample.getModificationDate());
            sampleCodes.add(sample.getCode());
        }
        return result;
    }

    private IFileSystemViewResponse listSampleTypes(IResolverContext context) {
        SampleTypeSearchCriteria searchCriteria = new SampleTypeSearchCriteria();
        searchCriteria.withListable().thatEquals(true);
        List sampleTypes = context.getApi().searchSampleTypes(context.getSessionToken(), searchCriteria, new SampleTypeFetchOptions()).getObjects();
        IDirectoryResponse response = context.createDirectoryResponse();
        for (SampleType type : sampleTypes) {
            response.addDirectory(type.getCode());
        }
        return response;
    }

    @Override
    public void initialize(String name, String code) {
    }
}

