/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.server.fs.resolver;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.dataset.fetchoptions.DataSetFetchOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.dataset.id.DataSetPermId;
import ch.systemsx.cisd.openbis.common.io.hierarchical_content.api.IHierarchicalContent;
import ch.systemsx.cisd.openbis.dss.generic.server.fs.ResolverContext;
import ch.systemsx.cisd.openbis.dss.generic.server.fs.api.IResolver;
import ch.systemsx.cisd.openbis.dss.generic.server.fs.api.IResolverContext;
import ch.systemsx.cisd.openbis.dss.generic.server.fs.api.file.IFileSystemViewResponse;
import ch.systemsx.cisd.openbis.dss.generic.server.fs.resolver.HierarchicalContentResolver;
import ch.systemsx.cisd.openbis.dss.generic.server.ftp.Cache;
import java.util.Collections;
import java.util.Map;

public class DataSetContentResolver
implements IResolver {
    String dataSetCode;

    public DataSetContentResolver(String dataSetCode) {
        this.dataSetCode = dataSetCode;
    }

    @Override
    public IFileSystemViewResponse resolve(String[] subPath, IResolverContext context) {
        Cache cache = ((ResolverContext)context).getCache();
        Boolean hasAccess = cache.getAccess(this.dataSetCode);
        if (hasAccess == null) {
            DataSetPermId id = new DataSetPermId(this.dataSetCode);
            Map dataSets = context.getApi().getDataSets(context.getSessionToken(), Collections.singletonList(id), new DataSetFetchOptions());
            hasAccess = dataSets.containsKey(id);
            cache.putAccess(this.dataSetCode, hasAccess);
        }
        if (!hasAccess.booleanValue()) {
            return context.createNonExistingFileResponse("Path doesn't exist or unauthorized");
        }
        IHierarchicalContent content = cache.getContent(this.dataSetCode);
        if (content == null) {
            content = context.getContentProvider().asContent(this.dataSetCode);
            cache.putContent(this.dataSetCode, content);
        }
        HierarchicalContentResolver resolver = new HierarchicalContentResolver(content);
        return resolver.resolve(subPath, context);
    }
}

