/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.server.fs.resolver;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.dataset.DataSet;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.experiment.Experiment;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.experiment.fetchoptions.ExperimentFetchOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.experiment.id.IExperimentId;
import ch.systemsx.cisd.openbis.dss.generic.server.fs.api.IResolver;
import ch.systemsx.cisd.openbis.dss.generic.server.fs.api.IResolverContext;
import ch.systemsx.cisd.openbis.dss.generic.server.fs.api.file.IDirectoryResponse;
import ch.systemsx.cisd.openbis.dss.generic.server.fs.api.file.IFileSystemViewResponse;
import ch.systemsx.cisd.openbis.dss.generic.server.fs.resolver.DataSetContentResolver;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;

class ExperimentLevelResolver
implements IResolver {
    private IExperimentId experimentId;

    public ExperimentLevelResolver(IExperimentId experimentId) {
        this.experimentId = experimentId;
    }

    @Override
    public IFileSystemViewResponse resolve(String[] subPath, IResolverContext context) {
        if (subPath.length == 0) {
            ExperimentFetchOptions fetchOptions = new ExperimentFetchOptions();
            fetchOptions.withDataSets();
            Map experiments = context.getApi().getExperiments(context.getSessionToken(), Collections.singletonList(this.experimentId), fetchOptions);
            Experiment exp = (Experiment)experiments.get(this.experimentId);
            if (exp == null) {
                return context.createNonExistingFileResponse(null);
            }
            IDirectoryResponse response = context.createDirectoryResponse();
            for (DataSet dataSet : exp.getDataSets()) {
                response.addDirectory(dataSet.getCode(), dataSet.getModificationDate());
            }
            return response;
        }
        String dataSetCode = subPath[0];
        String[] remaining = Arrays.copyOfRange(subPath, 1, subPath.length);
        return new DataSetContentResolver(dataSetCode).resolve(remaining, context);
    }
}

