/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.server.fs.resolver;

import ch.systemsx.cisd.common.shared.basic.string.StringUtils;
import ch.systemsx.cisd.openbis.common.io.hierarchical_content.api.IHierarchicalContent;
import ch.systemsx.cisd.openbis.common.io.hierarchical_content.api.IHierarchicalContentNode;
import ch.systemsx.cisd.openbis.dss.generic.server.fs.api.IResolver;
import ch.systemsx.cisd.openbis.dss.generic.server.fs.api.IResolverContext;
import ch.systemsx.cisd.openbis.dss.generic.server.fs.api.file.IDirectoryResponse;
import ch.systemsx.cisd.openbis.dss.generic.server.fs.api.file.IFileSystemViewResponse;

class HierarchicalContentResolver
implements IResolver {
    private IHierarchicalContent content;

    public HierarchicalContentResolver(IHierarchicalContent content) {
        this.content = content;
    }

    @Override
    public IFileSystemViewResponse resolve(String[] subPath, IResolverContext context) {
        IHierarchicalContentNode rootNode = subPath.length == 0 ? this.content.getRootNode() : this.content.tryGetNode(StringUtils.join((Object[])subPath, (String)"/"));
        if (rootNode == null) {
            return context.createNonExistingFileResponse(null);
        }
        if (!rootNode.isDirectory()) {
            return context.createFileResponse(rootNode, this.content);
        }
        IDirectoryResponse response = context.createDirectoryResponse();
        for (IHierarchicalContentNode node : rootNode.getChildNodes()) {
            if (node.isDirectory()) {
                response.addDirectory(node.getName(), node.getLastModified());
                continue;
            }
            response.addFile(node.getName(), node);
        }
        return response;
    }
}

