/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.server.fs.resolver;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.experiment.Experiment;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.experiment.id.ExperimentIdentifier;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.experiment.id.IExperimentId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.project.Project;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.project.fetchoptions.ProjectFetchOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.project.id.ProjectIdentifier;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.sample.Sample;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.sample.id.ISampleId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.sample.id.SampleIdentifier;
import ch.systemsx.cisd.openbis.dss.generic.server.fs.api.IResolverContext;
import ch.systemsx.cisd.openbis.dss.generic.server.fs.api.file.IDirectoryResponse;
import ch.systemsx.cisd.openbis.dss.generic.server.fs.api.file.IFileSystemViewResponse;
import ch.systemsx.cisd.openbis.dss.generic.server.fs.resolver.AbstractResolver;
import ch.systemsx.cisd.openbis.dss.generic.server.fs.resolver.ExperimentLevelResolver;
import ch.systemsx.cisd.openbis.dss.generic.server.fs.resolver.SampleLevelResolver;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;

class ProjectLevelResolver
extends AbstractResolver {
    private ProjectIdentifier projectIdentifier;

    public ProjectLevelResolver(String spaceCode, String projectCode) {
        this.projectIdentifier = new ProjectIdentifier(spaceCode, projectCode);
    }

    @Override
    public IFileSystemViewResponse resolve(String[] subPath, IResolverContext context) {
        if (subPath.length == 0) {
            ProjectFetchOptions fetchOptions = new ProjectFetchOptions();
            fetchOptions.withExperiments();
            fetchOptions.withSamples().withExperiment();
            Map projects = context.getApi().getProjects(context.getSessionToken(), Collections.singletonList(this.projectIdentifier), fetchOptions);
            Project project = (Project)projects.get(this.projectIdentifier);
            IDirectoryResponse response = context.createDirectoryResponse();
            if (project == null) {
                return context.createNonExistingFileResponse(null);
            }
            HashSet<String> experimentPermIds = new HashSet<String>();
            for (Experiment exp : project.getExperiments()) {
                String permId = exp.getPermId().getPermId();
                experimentPermIds.add(permId);
                response.addDirectory(exp.getCode(), exp.getModificationDate());
            }
            for (Sample sample : project.getSamples()) {
                Experiment experiment = sample.getExperiment();
                if (experiment != null && experimentPermIds.contains(experiment.getPermId().getPermId())) continue;
                response.addDirectory(this.getFullCodeWithPrefix(sample), sample.getModificationDate());
            }
            return response;
        }
        String item = subPath[0];
        String[] remaining = Arrays.copyOfRange(subPath, 1, subPath.length);
        String pathWithPrefix = this.projectIdentifier.getIdentifier() + "/" + item;
        String path = this.removeSamplePrefix(pathWithPrefix);
        if (this.hasSamplePrefix(pathWithPrefix)) {
            SampleIdentifier sampleIdentifier = new SampleIdentifier(path);
            return new SampleLevelResolver((ISampleId)sampleIdentifier).resolve(remaining, context);
        }
        return new ExperimentLevelResolver((IExperimentId)new ExperimentIdentifier(path)).resolve(remaining, context);
    }
}

