/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.server.fs.resolver;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.space.Space;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.space.fetchoptions.SpaceFetchOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.space.search.SpaceSearchCriteria;
import ch.systemsx.cisd.openbis.dss.generic.server.fs.api.IResolver;
import ch.systemsx.cisd.openbis.dss.generic.server.fs.api.IResolverContext;
import ch.systemsx.cisd.openbis.dss.generic.server.fs.api.file.IDirectoryResponse;
import ch.systemsx.cisd.openbis.dss.generic.server.fs.api.file.IFileSystemViewResponse;
import ch.systemsx.cisd.openbis.dss.generic.server.fs.resolver.SpaceLevelResolver;
import java.util.Arrays;
import java.util.List;

public class RootLevelResolver
implements IResolver {
    @Override
    public IFileSystemViewResponse resolve(String[] subPath, IResolverContext context) {
        if (subPath.length == 0) {
            List spaces = context.getApi().searchSpaces(context.getSessionToken(), new SpaceSearchCriteria(), new SpaceFetchOptions()).getObjects();
            IDirectoryResponse response = context.createDirectoryResponse();
            for (Space space : spaces) {
                response.addDirectory(space.getCode(), space.getModificationDate());
            }
            return response;
        }
        String item = subPath[0];
        String[] remaining = Arrays.copyOfRange(subPath, 1, subPath.length);
        SpaceLevelResolver resolver = new SpaceLevelResolver(item);
        return resolver.resolve(remaining, context);
    }
}

