/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.server.fs.resolver;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.dataset.DataSet;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.sample.Sample;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.sample.fetchoptions.SampleFetchOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.sample.id.ISampleId;
import ch.systemsx.cisd.openbis.dss.generic.server.fs.api.IResolver;
import ch.systemsx.cisd.openbis.dss.generic.server.fs.api.IResolverContext;
import ch.systemsx.cisd.openbis.dss.generic.server.fs.api.file.IDirectoryResponse;
import ch.systemsx.cisd.openbis.dss.generic.server.fs.api.file.IFileSystemViewResponse;
import ch.systemsx.cisd.openbis.dss.generic.server.fs.resolver.DataSetContentResolver;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;

class SampleLevelResolver
implements IResolver {
    private ISampleId sampleId;

    public SampleLevelResolver(ISampleId sampleId) {
        this.sampleId = sampleId;
    }

    @Override
    public IFileSystemViewResponse resolve(String[] subPath, IResolverContext context) {
        if (subPath.length == 0) {
            SampleFetchOptions fetchOptions = new SampleFetchOptions();
            fetchOptions.withDataSets();
            Map samples = context.getApi().getSamples(context.getSessionToken(), Collections.singletonList(this.sampleId), fetchOptions);
            Sample sample = (Sample)samples.get(this.sampleId);
            if (sample == null) {
                return context.createNonExistingFileResponse(null);
            }
            IDirectoryResponse response = context.createDirectoryResponse();
            for (DataSet dataSet : sample.getDataSets()) {
                response.addDirectory(dataSet.getCode(), dataSet.getModificationDate());
            }
            return response;
        }
        String dataSetCode = subPath[0];
        String[] remaining = Arrays.copyOfRange(subPath, 1, subPath.length);
        return new DataSetContentResolver(dataSetCode).resolve(remaining, context);
    }
}

