/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.server.fs.resolver;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.project.Project;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.sample.Sample;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.sample.id.ISampleId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.sample.id.SampleIdentifier;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.space.Space;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.space.fetchoptions.SpaceFetchOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.space.id.SpacePermId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.space.search.SpaceSearchCriteria;
import ch.systemsx.cisd.openbis.dss.generic.server.fs.api.IResolverContext;
import ch.systemsx.cisd.openbis.dss.generic.server.fs.api.file.IDirectoryResponse;
import ch.systemsx.cisd.openbis.dss.generic.server.fs.api.file.IFileSystemViewResponse;
import ch.systemsx.cisd.openbis.dss.generic.server.fs.resolver.AbstractResolver;
import ch.systemsx.cisd.openbis.dss.generic.server.fs.resolver.ProjectLevelResolver;
import ch.systemsx.cisd.openbis.dss.generic.server.fs.resolver.SampleLevelResolver;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;

class SpaceLevelResolver
extends AbstractResolver {
    String spaceCode;

    public SpaceLevelResolver(String spaceCode) {
        this.spaceCode = spaceCode;
    }

    @Override
    public IFileSystemViewResponse resolve(String[] subPath, IResolverContext context) {
        if (subPath.length == 0) {
            SpaceSearchCriteria searchCriteria = new SpaceSearchCriteria();
            searchCriteria.withCode().thatEquals(this.spaceCode);
            SpaceFetchOptions fetchOptions = new SpaceFetchOptions();
            fetchOptions.withProjects();
            fetchOptions.withSamples().withProject();
            SpacePermId spaceCodeId = new SpacePermId(this.spaceCode);
            Map spaces = context.getApi().getSpaces(context.getSessionToken(), Collections.singletonList(spaceCodeId), fetchOptions);
            Space space = (Space)spaces.get(spaceCodeId);
            if (space == null) {
                return context.createNonExistingFileResponse(null);
            }
            IDirectoryResponse response = context.createDirectoryResponse();
            HashSet<String> projectPermIds = new HashSet<String>();
            for (Project project : space.getProjects()) {
                response.addDirectory(project.getCode(), project.getModificationDate());
                String permId = project.getPermId().getPermId();
                projectPermIds.add(permId);
            }
            for (Sample sample : space.getSamples()) {
                Project project = sample.getProject();
                if (project != null && projectPermIds.contains(project.getPermId().getPermId())) continue;
                response.addDirectory(this.getFullCodeWithPrefix(sample), sample.getModificationDate());
            }
            return response;
        }
        String item = subPath[0];
        String[] remaining = Arrays.copyOfRange(subPath, 1, subPath.length);
        String pathWithPrefix = "/" + this.spaceCode + "/" + item;
        if (this.hasSamplePrefix(pathWithPrefix)) {
            SampleIdentifier sampleIdentifier = new SampleIdentifier(this.removeSamplePrefix(pathWithPrefix));
            return new SampleLevelResolver((ISampleId)sampleIdentifier).resolve(remaining, context);
        }
        return new ProjectLevelResolver(this.spaceCode, this.removeSamplePrefix(item)).resolve(remaining, context);
    }
}

