/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.server.ftp;

import ch.systemsx.cisd.common.utilities.ITimeProvider;
import ch.systemsx.cisd.openbis.common.io.hierarchical_content.api.IHierarchicalContent;
import ch.systemsx.cisd.openbis.dss.generic.server.ftp.Node;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.DataSet;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.AbstractExternalData;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Experiment;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.ftpserver.ftplet.FtpFile;

public class Cache {
    static final long LIVE_TIME = 1000L;
    private final Map<String, Node> nodesByPath = new HashMap<String, Node>();
    private final Map<String, TimeStampedObject<FtpFile>> filesByPath = new HashMap<String, TimeStampedObject<FtpFile>>();
    private final Map<String, TimeStampedObject<DataSet>> dataSetsByCode = new HashMap<String, TimeStampedObject<DataSet>>();
    private final Map<String, TimeStampedObject<List<AbstractExternalData>>> dataSetsByExperiment = new HashMap<String, TimeStampedObject<List<AbstractExternalData>>>();
    private final Map<String, TimeStampedObject<AbstractExternalData>> externalData = new HashMap<String, TimeStampedObject<AbstractExternalData>>();
    private final Map<String, TimeStampedObject<Experiment>> experiments = new HashMap<String, TimeStampedObject<Experiment>>();
    private final ITimeProvider timeProvider;
    private final Map<String, TimeStampedObject<FtpFile>> v3Responses = new HashMap<String, TimeStampedObject<FtpFile>>();
    private final Map<String, TimeStampedObject<IHierarchicalContent>> contents = new HashMap<String, TimeStampedObject<IHierarchicalContent>>();
    private final Map<String, TimeStampedObject<Boolean>> accessData = new HashMap<String, TimeStampedObject<Boolean>>();

    public Cache(ITimeProvider timeProvider) {
        this.timeProvider = timeProvider;
    }

    public void putNode(Node node, String path) {
        this.nodesByPath.put(path, node);
    }

    public Node getNode(String path) {
        return this.nodesByPath.get(path);
    }

    public void putFile(FtpFile file, String path) {
        this.filesByPath.put(path, this.timestamp(file));
    }

    public FtpFile getFile(String path) {
        return (FtpFile)this.getObject(this.filesByPath, path);
    }

    public void putDataSetsForExperiment(List<AbstractExternalData> dataSets, String experimentPermId) {
        this.dataSetsByExperiment.put(experimentPermId, this.timestamp(dataSets));
    }

    public List<AbstractExternalData> getDataSetsByExperiment(String experimentPermId) {
        return (List)this.getObject(this.dataSetsByExperiment, experimentPermId);
    }

    public void putDataSet(DataSet dataSet) {
        this.dataSetsByCode.put(dataSet.getCode(), this.timestamp(dataSet));
    }

    public DataSet getDataSet(String dataSetCode) {
        return (DataSet)this.getObject(this.dataSetsByCode, dataSetCode);
    }

    public AbstractExternalData getExternalData(String code) {
        return (AbstractExternalData)this.getObject(this.externalData, code);
    }

    public void putExternalData(AbstractExternalData dataSet) {
        this.externalData.put(dataSet.getCode(), this.timestamp(dataSet));
    }

    public Experiment getExperiment(String experimentId) {
        return (Experiment)this.getObject(this.experiments, experimentId);
    }

    public void putExperiment(Experiment experiment) {
        this.experiments.put(experiment.getIdentifier(), this.timestamp(experiment));
    }

    public FtpFile getResponse(String key) {
        return (FtpFile)this.getObject(this.v3Responses, key);
    }

    public void putResponse(String key, FtpFile file) {
        this.v3Responses.put(key, this.timestamp(file));
    }

    public IHierarchicalContent getContent(String key) {
        return (IHierarchicalContent)this.getObject(this.contents, key);
    }

    public void putContent(String key, IHierarchicalContent content) {
        this.contents.put(key, this.timestamp(content));
    }

    public Boolean getAccess(String dataSetCode) {
        return (Boolean)this.getObject(this.accessData, dataSetCode);
    }

    public void putAccess(String dataSetCode, Boolean access) {
        this.accessData.put(dataSetCode, this.timestamp(access));
    }

    private <T> TimeStampedObject<T> timestamp(T object) {
        return new TimeStampedObject<T>(object, this.timeProvider.getTimeInMilliseconds());
    }

    private <T> T getObject(Map<String, TimeStampedObject<T>> map, String key) {
        TimeStampedObject<T> timeStampedObject = map.get(key);
        if (timeStampedObject == null) {
            return null;
        }
        if (this.timeProvider.getTimeInMilliseconds() - ((TimeStampedObject)timeStampedObject).timestamp > 1000L) {
            map.remove(key);
            return null;
        }
        return (T)((TimeStampedObject)timeStampedObject).object;
    }

    private static final class TimeStampedObject<T> {
        private final long timestamp;
        private final T object;

        public TimeStampedObject(T object, long timestamp) {
            this.object = object;
            this.timestamp = timestamp;
        }
    }
}

