/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.server.ftp;

import ch.ethz.sis.openbis.generic.asapi.v3.IApplicationServerApi;
import ch.systemsx.cisd.base.exceptions.CheckedExceptionTunnel;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.utilities.ITimeProvider;
import ch.systemsx.cisd.common.utilities.SystemTimeProvider;
import ch.systemsx.cisd.openbis.dss.generic.server.ftp.Cache;
import ch.systemsx.cisd.openbis.dss.generic.server.ftp.FtpPathResolverContext;
import ch.systemsx.cisd.openbis.dss.generic.server.ftp.IFtpPathResolverRegistry;
import ch.systemsx.cisd.openbis.generic.shared.IServiceForDataStoreServer;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.IGeneralInformationService;
import ch.systemsx.cisd.openbis.generic.shared.util.Key;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.URI;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.ftpserver.ftplet.FileSystemView;
import org.apache.ftpserver.ftplet.FtpException;
import org.apache.ftpserver.ftplet.FtpFile;
import org.apache.log4j.Logger;

public class DSSFileSystemView
implements FileSystemView {
    private static final Set<String> METHOD_NAMES = new HashSet<String>(Arrays.asList("tryToGetExperiment", "listDataSetsByExperimentID"));
    private static final Logger operationLog = LogFactory.getLogger((LogCategory)LogCategory.OPERATION, DSSFileSystemView.class);
    private final String sessionToken;
    private final IServiceForDataStoreServer service;
    private final IGeneralInformationService generalInfoService;
    private final IApplicationServerApi v3api;
    private FtpFile workingDirectory;
    private final IFtpPathResolverRegistry pathResolverRegistry;
    private Cache cache;

    public DSSFileSystemView(String sessionToken, IServiceForDataStoreServer service, IGeneralInformationService generalInfoService, IApplicationServerApi v3api, IFtpPathResolverRegistry pathResolverRegistry) throws FtpException {
        this(sessionToken, service, generalInfoService, v3api, pathResolverRegistry, new Cache((ITimeProvider)SystemTimeProvider.SYSTEM_TIME_PROVIDER));
    }

    public DSSFileSystemView(String sessionToken, IServiceForDataStoreServer service, IGeneralInformationService generalInfoService, IApplicationServerApi v3api, IFtpPathResolverRegistry pathResolverRegistry, Cache cache) throws FtpException {
        this.sessionToken = sessionToken;
        this.cache = cache;
        this.service = (IServiceForDataStoreServer)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{IServiceForDataStoreServer.class}, (InvocationHandler)new ServiceInvocationHandler(service));
        this.generalInfoService = generalInfoService;
        this.v3api = v3api;
        this.pathResolverRegistry = pathResolverRegistry;
        this.workingDirectory = this.getFile("/");
    }

    public boolean changeWorkingDirectory(String path) throws FtpException {
        FtpFile ftpFile = this.getFile(path);
        if (ftpFile != null && ftpFile.isDirectory()) {
            this.workingDirectory = ftpFile;
            return true;
        }
        return false;
    }

    public void dispose() {
    }

    public FtpFile getFile(String path) throws FtpException {
        String normalizedPath = this.normalizePath(path);
        operationLog.info((Object)("path:>" + path + "<, normalized path:>" + normalizedPath + "<"));
        if (this.workingDirectory != null && this.workingDirectory.getAbsolutePath().equals(normalizedPath)) {
            return this.workingDirectory;
        }
        try {
            FtpPathResolverContext context = new FtpPathResolverContext(this.sessionToken, this.service, this.generalInfoService, this.v3api, this.pathResolverRegistry, this.cache, path);
            return this.pathResolverRegistry.resolve(normalizedPath, context);
        }
        catch (RuntimeException rex) {
            Exception realThrowable = CheckedExceptionTunnel.unwrapIfNecessary((Exception)rex);
            String message = String.format("Error while resolving FTP path '%s' : %s", path, realThrowable.getMessage());
            if (!(realThrowable instanceof UserFailureException)) {
                operationLog.error((Object)message, (Throwable)realThrowable);
            }
            throw new FtpException(message);
        }
    }

    private String normalizePath(String path) throws FtpException {
        String fullPath = path.trim();
        if (fullPath.startsWith("./")) {
            fullPath = fullPath.substring(2);
        }
        if (!fullPath.startsWith("/")) {
            String absolutePath = this.workingDirectory.getAbsolutePath();
            if (!absolutePath.endsWith("/")) {
                absolutePath = absolutePath + "/";
            }
            fullPath = absolutePath + fullPath;
        }
        try {
            String fullPathURLEncoded = URLEncoder.encode(fullPath, StandardCharsets.UTF_8.toString());
            fullPathURLEncoded = fullPathURLEncoded.replace("%2F", "/");
            URI uri = new URI(fullPathURLEncoded);
            String normalizedPathWithURI = uri.normalize().toString();
            String normalizedPath = URLDecoder.decode(normalizedPathWithURI, StandardCharsets.UTF_8.toString());
            normalizedPath = normalizedPath.replaceAll("/*$", "");
            normalizedPath = normalizedPath.replaceAll("/+", "/");
            return StringUtils.isBlank((CharSequence)normalizedPath) ? "/" : normalizedPath;
        }
        catch (Exception ex) {
            operationLog.error((Object)ex);
            throw new FtpException("Cannot parse path " + fullPath, (Throwable)ex);
        }
    }

    public FtpFile getHomeDirectory() throws FtpException {
        return this.getFile("/");
    }

    public FtpFile getWorkingDirectory() throws FtpException {
        return this.workingDirectory;
    }

    public boolean isRandomAccessible() throws FtpException {
        return true;
    }

    public String getSessionToken() {
        return this.sessionToken;
    }

    private final class ServiceInvocationHandler
    implements InvocationHandler {
        private final Map<Key, Object> objectCache = new HashMap<Key, Object>();
        private final IServiceForDataStoreServer openbisService;

        private ServiceInvocationHandler(IServiceForDataStoreServer service) {
            this.openbisService = service;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (METHOD_NAMES.contains(method.getName())) {
                Key key = new Key(args);
                Object result = this.objectCache.get(key);
                if (result == null) {
                    result = this.invoke(method, args);
                    this.objectCache.put(key, result);
                }
                return result;
            }
            return this.invoke(method, args);
        }

        private Object invoke(Method method, Object[] args) throws IllegalAccessException, InvocationTargetException {
            return method.invoke((Object)this.openbisService, args);
        }
    }
}

