/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.server.ftp;

import ch.systemsx.cisd.openbis.common.io.hierarchical_content.IHierarchicalContentNodeFilter;
import ch.systemsx.cisd.openbis.common.io.hierarchical_content.api.IHierarchicalContent;
import ch.systemsx.cisd.openbis.common.io.hierarchical_content.api.IHierarchicalContentNode;
import ch.systemsx.cisd.openbis.dss.generic.server.ftp.Cache;
import ch.systemsx.cisd.openbis.dss.generic.server.ftp.resolver.FtpFileImpl;
import org.apache.ftpserver.ftplet.FtpFile;

public class FtpFileFactory {
    public static FtpFile createFtpFile(String dataSetCode, String path, IHierarchicalContentNode contentNode, IHierarchicalContent content, IHierarchicalContentNodeFilter childrenFilter, Cache cache) {
        return FtpFileFactory.createFtpFile(dataSetCode, path, contentNode, content, childrenFilter, FtpFileFactory.getLastModified(contentNode), cache);
    }

    public static FtpFile createFtpFile(String dataSetCode, String path, IHierarchicalContentNode contentNode, IHierarchicalContent content, IHierarchicalContentNodeFilter childrenFilter, long lastModified, Cache cache) {
        FtpFile file = cache.getFile(path);
        if (file == null) {
            file = new FtpFileImpl(dataSetCode, path, contentNode.getRelativePath(), contentNode.isDirectory(), FtpFileFactory.getSize(contentNode), lastModified, content, childrenFilter, cache);
            cache.putFile(file, path);
        }
        return file;
    }

    private static long getSize(IHierarchicalContentNode contentNode) {
        if (contentNode.isDirectory()) {
            return 0L;
        }
        return contentNode.getFileLength();
    }

    private static long getLastModified(IHierarchicalContentNode contentNode) {
        try {
            return contentNode.getLastModified();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            return 0L;
        }
    }
}

