/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.server.ftp;

import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.properties.ExtendedProperties;
import ch.systemsx.cisd.common.properties.PropertyUtils;
import ch.systemsx.cisd.openbis.dss.generic.server.fs.FtpPathResolverRegistry;
import ch.systemsx.cisd.openbis.dss.generic.server.ftp.IFtpPathResolverRegistry;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Logger;

public class FtpPathResolverConfig {
    static final String DATASET_DISPLAY_TEMPLATE_KEY = "dataset.display.template";
    static final String SHOW_PARENTS_AND_CHILDREN_KEY = "dataset.show-parents-and-children";
    static final String DATASET_FILELIST_SUBPATH_KEY = "dataset.filelist.subpath.";
    static final String DATASET_FILELIST_FILTER_KEY = "dataset.filelist.filter.";
    static final String PATH_RESOLVER_KEY = "resolver-class";
    private static final String DEFAULT_DATASET_TEMPLATE = "${dataSetCode}";
    private static final Logger operationLog = LogFactory.getLogger((LogCategory)LogCategory.OPERATION, FtpPathResolverConfig.class);
    private boolean showParentsAndChildren;
    private String dataSetDisplayTemplate = "";
    private Map<String, String> fileListSubPaths = new HashMap<String, String>();
    private Map<String, String> fileListFilters = new HashMap<String, String>();
    private final String resolverClass;
    private final Properties properties;

    public FtpPathResolverConfig(Properties props) {
        this.dataSetDisplayTemplate = PropertyUtils.getProperty((Properties)props, (String)DATASET_DISPLAY_TEMPLATE_KEY, (String)DEFAULT_DATASET_TEMPLATE);
        this.showParentsAndChildren = PropertyUtils.getBoolean((Properties)props, (String)SHOW_PARENTS_AND_CHILDREN_KEY, (boolean)false);
        this.resolverClass = PropertyUtils.getProperty((Properties)props, (String)PATH_RESOLVER_KEY, (String)FtpPathResolverRegistry.class.getCanonicalName());
        this.properties = props;
        ExtendedProperties fileListSubPathProps = ExtendedProperties.getSubset((Properties)props, (String)DATASET_FILELIST_SUBPATH_KEY, (boolean)true);
        for (Object key : fileListSubPathProps.keySet()) {
            String dataSetType = key.toString();
            String subPath = fileListSubPathProps.getProperty(dataSetType);
            this.fileListSubPaths.put(dataSetType, subPath);
        }
        ExtendedProperties fileListFilterProps = ExtendedProperties.getSubset((Properties)props, (String)DATASET_FILELIST_FILTER_KEY, (boolean)true);
        for (Object key : fileListFilterProps.keySet()) {
            String dataSetType = key.toString();
            String filter = fileListFilterProps.getProperty(dataSetType);
            this.fileListFilters.put(dataSetType, filter);
        }
    }

    public String getDataSetDisplayTemplate() {
        return this.dataSetDisplayTemplate;
    }

    public boolean isShowParentsAndChildren() {
        return this.showParentsAndChildren;
    }

    public Map<String, String> getFileListSubPaths() {
        return Collections.unmodifiableMap(this.fileListSubPaths);
    }

    public Map<String, String> getFileListFilters() {
        return Collections.unmodifiableMap(this.fileListFilters);
    }

    public void logStartupInfo(String serverType) {
        String message;
        operationLog.info((Object)(serverType + " Server data set display template : " + this.dataSetDisplayTemplate));
        for (Map.Entry<String, String> subpathEntry : this.fileListSubPaths.entrySet()) {
            message = String.format("%s Server subpath configuration for data set type '%s' : '%s'", serverType, subpathEntry.getKey(), subpathEntry.getValue());
            operationLog.info((Object)message);
        }
        for (Map.Entry<String, String> filterEntry : this.fileListFilters.entrySet()) {
            message = String.format("%s Server file filter configuration for data set type '%s' : '%s'", serverType, filterEntry.getKey(), filterEntry.getValue());
            operationLog.info((Object)message);
        }
    }

    public Properties getProperties() {
        return this.properties;
    }

    public IFtpPathResolverRegistry getResolverRegistry() {
        try {
            Class<?> clazz = Class.forName(this.resolverClass);
            Object instance = clazz.newInstance();
            IFtpPathResolverRegistry registry = (IFtpPathResolverRegistry)instance;
            registry.initialize(this);
            operationLog.info((Object)("Succesfully initialized path resolver of type " + registry.getClass().getName()));
            return registry;
        }
        catch (ClassNotFoundException ex) {
            throw new UserFailureException("Failed to create PathResolverRegistry. Couldn't find class " + this.resolverClass, (Throwable)ex);
        }
        catch (InstantiationException ex) {
            throw new UserFailureException("Failed to create PathResolverRegistry. Couldn't instantiate object of a class " + this.resolverClass, (Throwable)ex);
        }
        catch (IllegalAccessException ex) {
            throw new UserFailureException("Failed to create PathResolverRegistry. Couldn't instantiate object of a class " + this.resolverClass, (Throwable)ex);
        }
        catch (ClassCastException ex) {
            throw new UserFailureException("Failed to create PathResolverRegistry. Couldn't cast object of a class " + this.resolverClass + " to " + IFtpPathResolverRegistry.class.getName(), (Throwable)ex);
        }
    }
}

