/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.server.ftp;

import ch.ethz.sis.openbis.generic.asapi.v3.IApplicationServerApi;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.common.server.ISessionTokenProvider;
import ch.systemsx.cisd.openbis.dss.generic.server.fs.ResolverContext;
import ch.systemsx.cisd.openbis.dss.generic.server.ftp.Cache;
import ch.systemsx.cisd.openbis.dss.generic.server.ftp.IFtpPathResolverRegistry;
import ch.systemsx.cisd.openbis.generic.shared.IServiceForDataStoreServer;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.IGeneralInformationService;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.DataSet;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.DataSetFetchOption;
import ch.systemsx.cisd.openbis.generic.shared.basic.IIdAndCodeHolder;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.AbstractExternalData;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Experiment;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ExperimentFetchOptions;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ExperimentIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ExperimentIdentifierFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;

public class FtpPathResolverContext
implements ISessionTokenProvider {
    private final String sessionToken;
    private final IServiceForDataStoreServer service;
    private final IGeneralInformationService generalInfoService;
    private final IApplicationServerApi v3api;
    private final IFtpPathResolverRegistry resolverRegistry;
    private final Cache cache;
    private final ResolverContext resolverContext;

    public FtpPathResolverContext(String sessionToken, IServiceForDataStoreServer service, IGeneralInformationService generalInfoService, IApplicationServerApi v3api, IFtpPathResolverRegistry resolverRegistry, Cache cache, String path) {
        this.sessionToken = sessionToken;
        this.service = service;
        this.generalInfoService = generalInfoService;
        this.resolverRegistry = resolverRegistry;
        this.v3api = v3api;
        this.cache = cache;
        this.resolverContext = new ResolverContext(sessionToken, cache, v3api, path);
    }

    public FtpPathResolverContext cloneForPath(String path) {
        return new FtpPathResolverContext(this.sessionToken, this.service, this.generalInfoService, this.v3api, this.resolverRegistry, this.cache, path);
    }

    public String getSessionToken() {
        return this.sessionToken;
    }

    public IServiceForDataStoreServer getService() {
        return this.service;
    }

    public IApplicationServerApi getV3Api() {
        return this.v3api;
    }

    public Cache getCache() {
        return this.cache;
    }

    public DataSet getDataSet(String dataSetCode) {
        DataSet dataSet = this.cache.getDataSet(dataSetCode);
        if (dataSet == null) {
            EnumSet<DataSetFetchOption> fetchOptions = EnumSet.of(DataSetFetchOption.BASIC, DataSetFetchOption.PARENTS, DataSetFetchOption.CHILDREN);
            List dataSetsWithMetaData = this.generalInfoService.getDataSetMetaData(this.sessionToken, Arrays.asList(dataSetCode), fetchOptions);
            dataSet = (DataSet)dataSetsWithMetaData.get(0);
            this.cache.putDataSet(dataSet);
        }
        return dataSet;
    }

    public List<AbstractExternalData> listDataSetsByCode(List<String> codes) {
        ArrayList<String> codesToAskFor = new ArrayList<String>();
        ArrayList<AbstractExternalData> dataSets = new ArrayList<AbstractExternalData>();
        for (String code : codes) {
            AbstractExternalData dataSet = this.cache.getExternalData(code);
            if (dataSet == null) {
                codesToAskFor.add(code);
                continue;
            }
            dataSets.add(dataSet);
        }
        if (!codesToAskFor.isEmpty()) {
            List newDataSets = this.service.listDataSetsByCode(this.sessionToken, codesToAskFor);
            for (AbstractExternalData newDataSet : newDataSets) {
                this.cache.putExternalData(newDataSet);
                dataSets.add(newDataSet);
            }
        }
        return dataSets;
    }

    public Experiment getExperiment(String experimentId) {
        Experiment experiment = this.cache.getExperiment(experimentId);
        if (experiment == null) {
            ExperimentIdentifier experimentIdentifier = new ExperimentIdentifierFactory(experimentId).createIdentifier();
            List result = this.service.listExperiments(this.sessionToken, Collections.singletonList(experimentIdentifier), new ExperimentFetchOptions());
            if (result.isEmpty()) {
                throw new UserFailureException("Unknown experiment '" + experimentIdentifier + "'.");
            }
            experiment = (Experiment)result.get(0);
            this.cache.putExperiment(experiment);
        }
        return experiment;
    }

    public List<AbstractExternalData> getDataSets(Experiment experiment) {
        String experimentPermId = experiment.getPermId();
        List<AbstractExternalData> dataSets = this.cache.getDataSetsByExperiment(experimentPermId);
        if (dataSets == null) {
            dataSets = this.getAvailableDataSets(experiment);
            this.cache.putDataSetsForExperiment(dataSets, experimentPermId);
        }
        return dataSets;
    }

    private List<AbstractExternalData> getAvailableDataSets(Experiment experiment) {
        ArrayList<AbstractExternalData> availableDataSets = new ArrayList<AbstractExternalData>();
        List dataSets = this.service.listDataSetsByExperimentID(this.sessionToken, new TechId((IIdAndCodeHolder)experiment));
        for (AbstractExternalData dataSet : dataSets) {
            if (!dataSet.isAvailable()) continue;
            availableDataSets.add(dataSet);
        }
        return availableDataSets;
    }

    public IGeneralInformationService getGeneralInfoService() {
        return this.generalInfoService;
    }

    public IFtpPathResolverRegistry getResolverRegistry() {
        return this.resolverRegistry;
    }

    public ResolverContext getResolverContext() {
        return this.resolverContext;
    }
}

