/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.server.ftp;

import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.openbis.dss.generic.server.ftp.Cache;
import ch.systemsx.cisd.openbis.dss.generic.server.ftp.FtpPathResolverConfig;
import ch.systemsx.cisd.openbis.dss.generic.server.ftp.FtpPathResolverContext;
import ch.systemsx.cisd.openbis.dss.generic.server.ftp.IFtpPathResolver;
import ch.systemsx.cisd.openbis.dss.generic.server.ftp.IFtpPathResolverRegistry;
import ch.systemsx.cisd.openbis.dss.generic.server.ftp.NonExistingFtpFile;
import ch.systemsx.cisd.openbis.dss.generic.server.ftp.resolver.ExperimentFolderResolver;
import ch.systemsx.cisd.openbis.dss.generic.server.ftp.resolver.ProjectFolderResolver;
import ch.systemsx.cisd.openbis.dss.generic.server.ftp.resolver.RootFolderResolver;
import ch.systemsx.cisd.openbis.dss.generic.server.ftp.resolver.SpaceFolderResolver;
import ch.systemsx.cisd.openbis.dss.generic.server.ftp.resolver.TemplateBasedDataSetResourceResolver;
import java.util.ArrayList;
import java.util.List;
import org.apache.ftpserver.ftplet.FtpFile;
import org.apache.log4j.Logger;

public class FtpPathResolverRegistry
implements IFtpPathResolverRegistry {
    private static final Logger operationLog = LogFactory.getLogger((LogCategory)LogCategory.OPERATION, FtpPathResolverRegistry.class);
    private List<IFtpPathResolver> pathResolvers = new ArrayList<IFtpPathResolver>();

    @Override
    public void initialize(FtpPathResolverConfig config) {
        this.pathResolvers.add(new RootFolderResolver());
        this.pathResolvers.add(new SpaceFolderResolver());
        this.pathResolvers.add(new ProjectFolderResolver());
        TemplateBasedDataSetResourceResolver dataSetResolver = new TemplateBasedDataSetResourceResolver(config);
        this.pathResolvers.add(new ExperimentFolderResolver(dataSetResolver));
        this.pathResolvers.add(dataSetResolver);
    }

    IFtpPathResolver tryFindResolver(String path) {
        for (IFtpPathResolver ftpFileCreator : this.pathResolvers) {
            if (!ftpFileCreator.canResolve(path)) continue;
            return ftpFileCreator;
        }
        return null;
    }

    @Override
    public FtpFile resolve(String path, FtpPathResolverContext resolverContext) {
        Cache cache = resolverContext.getCache();
        FtpFile file = cache.getFile(path);
        if (file == null) {
            IFtpPathResolver resolver = this.tryFindResolver(path);
            if (resolver != null) {
                file = resolver.resolve(path, resolverContext);
            } else {
                String message = "Cannot find resolver for path '" + path + "'. Wrong user input ?";
                operationLog.warn((Object)message);
                file = FtpPathResolverRegistry.getNonExistingFile(path, message);
            }
            cache.putFile(file, path);
        }
        return file;
    }

    public static final FtpFile getNonExistingFile(String path, String errorMsgOrNull) {
        return new NonExistingFtpFile(path, errorMsgOrNull);
    }
}

