/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.server.ftp;

import ch.ethz.sis.openbis.generic.asapi.v3.IApplicationServerApi;
import ch.systemsx.cisd.base.exceptions.CheckedExceptionTunnel;
import ch.systemsx.cisd.common.exceptions.ConfigurationFailureException;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.properties.ExtendedProperties;
import ch.systemsx.cisd.common.properties.PropertyParametersUtil;
import ch.systemsx.cisd.openbis.dss.generic.server.ftp.DSSFileSystemView;
import ch.systemsx.cisd.openbis.dss.generic.server.ftp.FtpPathResolverConfig;
import ch.systemsx.cisd.openbis.dss.generic.server.ftp.FtpServerConfig;
import ch.systemsx.cisd.openbis.dss.generic.server.ftp.FtpUser;
import ch.systemsx.cisd.openbis.dss.generic.server.ftp.FtpUserManager;
import ch.systemsx.cisd.openbis.dss.generic.server.ftp.IFtpPathResolverRegistry;
import ch.systemsx.cisd.openbis.dss.generic.server.ftp.NonExistingFtpFile;
import ch.systemsx.cisd.openbis.dss.generic.server.ftp.resolver.AbstractFtpFileWithContent;
import ch.systemsx.cisd.openbis.dss.generic.shared.utils.DssPropertyParametersUtil;
import ch.systemsx.cisd.openbis.generic.shared.IServiceForDataStoreServer;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.IGeneralInformationService;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.channels.FileChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.AccessMode;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileStore;
import java.nio.file.FileSystem;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.ProviderMismatchException;
import java.nio.file.ReadOnlyFileSystemException;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileAttributeView;
import java.nio.file.attribute.FileTime;
import java.nio.file.attribute.GroupPrincipal;
import java.nio.file.attribute.PosixFileAttributes;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.UserPrincipal;
import java.nio.file.attribute.UserPrincipalLookupService;
import java.nio.file.spi.FileSystemProvider;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.X509ExtendedKeyManager;
import org.apache.commons.io.IOUtils;
import org.apache.ftpserver.ConnectionConfigFactory;
import org.apache.ftpserver.DataConnectionConfigurationFactory;
import org.apache.ftpserver.FtpServerFactory;
import org.apache.ftpserver.ftplet.Authentication;
import org.apache.ftpserver.ftplet.AuthenticationFailedException;
import org.apache.ftpserver.ftplet.DefaultFtpReply;
import org.apache.ftpserver.ftplet.DefaultFtplet;
import org.apache.ftpserver.ftplet.FtpException;
import org.apache.ftpserver.ftplet.FtpFile;
import org.apache.ftpserver.ftplet.FtpReply;
import org.apache.ftpserver.ftplet.FtpRequest;
import org.apache.ftpserver.ftplet.FtpSession;
import org.apache.ftpserver.ftplet.FtpletResult;
import org.apache.ftpserver.ftplet.User;
import org.apache.ftpserver.ftplet.UserManager;
import org.apache.ftpserver.listener.ListenerFactory;
import org.apache.ftpserver.ssl.SslConfigurationFactory;
import org.apache.ftpserver.usermanager.UsernamePasswordAuthentication;
import org.apache.log4j.Logger;
import org.apache.sshd.common.AttributeRepository;
import org.apache.sshd.common.file.FileSystemFactory;
import org.apache.sshd.common.file.util.BaseFileSystem;
import org.apache.sshd.common.file.util.BasePath;
import org.apache.sshd.common.keyprovider.AbstractKeyPairProvider;
import org.apache.sshd.common.keyprovider.KeyPairProvider;
import org.apache.sshd.common.session.Session;
import org.apache.sshd.common.session.SessionContext;
import org.apache.sshd.common.session.SessionListener;
import org.apache.sshd.server.SshServer;
import org.apache.sshd.server.auth.AsyncAuthException;
import org.apache.sshd.server.auth.password.PasswordAuthenticator;
import org.apache.sshd.server.auth.password.PasswordChangeRequiredException;
import org.apache.sshd.server.session.ServerSession;
import org.apache.sshd.server.subsystem.SubsystemFactory;
import org.apache.sshd.sftp.common.SftpConstants;
import org.apache.sshd.sftp.server.SftpErrorStatusDataHandler;
import org.apache.sshd.sftp.server.SftpSubsystemEnvironment;
import org.apache.sshd.sftp.server.SftpSubsystemFactory;

public class FtpServer
implements org.apache.ftpserver.ftplet.FileSystemFactory,
FileSystemFactory {
    private static final AttributeRepository.AttributeKey<User> USER_KEY = new AttributeRepository.AttributeKey();
    private static final Logger operationLog = LogFactory.getLogger((LogCategory)LogCategory.OPERATION, FtpServer.class);
    private final IServiceForDataStoreServer openBisService;
    private final FtpUserManager userManager;
    private final FtpServerConfig config;
    private final IFtpPathResolverRegistry pathResolverRegistry;
    private org.apache.ftpserver.FtpServer server;
    private final IGeneralInformationService generalInfoService;
    private final IApplicationServerApi v3api;
    private SshServer sshServer;
    private final Map<String, Set<DSSFileSystemView>> fileSystemViewsBySessionToken = new HashMap<String, Set<DSSFileSystemView>>();

    public FtpServer(IServiceForDataStoreServer openBisService, IGeneralInformationService generalInfoService, IApplicationServerApi v3api, FtpUserManager userManager) throws Exception {
        this.openBisService = openBisService;
        this.generalInfoService = generalInfoService;
        this.v3api = v3api;
        this.userManager = userManager;
        ExtendedProperties serviceProperties = DssPropertyParametersUtil.loadServiceProperties();
        Properties ftpProperties = PropertyParametersUtil.extractSingleSectionProperties((Properties)serviceProperties, (String)"ftp.server", (boolean)true).getProperties();
        this.config = new FtpServerConfig((Properties)serviceProperties);
        FtpPathResolverConfig resolverConfig = new FtpPathResolverConfig(ftpProperties);
        this.pathResolverRegistry = resolverConfig.getResolverRegistry();
        if (this.config.isStartServer()) {
            this.config.logStartupInfo();
            resolverConfig.logStartupInfo("SFTP/FTP");
            this.start();
        }
    }

    private void start() throws Exception {
        if (this.config.isSftpMode()) {
            this.sshServer = this.createSftpServer();
            operationLog.info((Object)String.format("Starting SFTP server on port %d ...", this.config.getSftpPort()));
            this.sshServer.start();
            operationLog.info((Object)"SFTP server started.");
        }
        if (this.config.isFtpMode()) {
            this.server = this.createFtpServer();
            operationLog.info((Object)String.format("Starting FTP server on port %d ...", this.config.getFtpPort()));
            this.server.start();
            operationLog.info((Object)"FTP server started.");
        }
    }

    private org.apache.ftpserver.FtpServer createFtpServer() {
        FtpServerFactory serverFactory = new FtpServerFactory();
        ListenerFactory factory = new ListenerFactory();
        factory.setPort(this.config.getFtpPort());
        if (this.config.isUseSSL()) {
            SslConfigurationFactory sslConfigFactory = new SslConfigurationFactory();
            sslConfigFactory.setKeystoreFile(this.config.getKeyStore());
            sslConfigFactory.setKeystorePassword(this.config.getKeyStorePassword());
            sslConfigFactory.setKeyPassword(this.config.getKeyPassword());
            factory.setSslConfiguration(sslConfigFactory.createSslConfiguration());
            factory.setImplicitSsl(this.config.isImplicitSSL());
            serverFactory.setFtplets(Collections.singletonMap("", new DefaultFtplet(){

                public FtpletResult beforeCommand(FtpSession session, FtpRequest request) throws FtpException, IOException {
                    String cmd = request.getCommand().toUpperCase();
                    if ("USER".equals(cmd) && !session.isSecure()) {
                        session.write((FtpReply)new DefaultFtpReply(500, "Control channel is not secure. Please, issue AUTH command first."));
                        return FtpletResult.SKIP;
                    }
                    return super.beforeCommand(session, request);
                }
            }));
        }
        DataConnectionConfigurationFactory dccFactory = new DataConnectionConfigurationFactory();
        dccFactory.setPassivePorts(this.config.getPassivePortsRange());
        if (this.config.isActiveModeEnabled()) {
            dccFactory.setActiveEnabled(true);
            dccFactory.setActiveLocalPort(this.config.getActiveLocalPort());
        }
        factory.setDataConnectionConfiguration(dccFactory.createDataConnectionConfiguration());
        serverFactory.addListener("default", factory.createListener());
        ConnectionConfigFactory connectionConfigFactory = new ConnectionConfigFactory();
        connectionConfigFactory.setMaxThreads(this.config.getMaxThreads().intValue());
        serverFactory.setConnectionConfig(connectionConfigFactory.createConnectionConfig());
        serverFactory.setFileSystem((org.apache.ftpserver.ftplet.FileSystemFactory)this);
        serverFactory.setUserManager((UserManager)this.userManager);
        return serverFactory.createServer();
    }

    private SshServer createSftpServer() {
        SshServer s = SshServer.setUpDefaultServer();
        KeystoreBasedKeyPairProvider keyPairProvider = new KeystoreBasedKeyPairProvider(this.config, operationLog);
        s.setKeyPairProvider((KeyPairProvider)keyPairProvider);
        s.setPort(this.config.getSftpPort());
        s.setSubsystemFactories(this.creatSubsystemFactories());
        s.setFileSystemFactory((FileSystemFactory)this);
        s.setPasswordAuthenticator(new PasswordAuthenticator(){

            public boolean authenticate(String username, String password, ServerSession session) throws PasswordChangeRequiredException, AsyncAuthException {
                try {
                    UsernamePasswordAuthentication authentication = new UsernamePasswordAuthentication(username, password);
                    User user = FtpServer.this.userManager.authenticate((Authentication)authentication);
                    session.setAttribute(USER_KEY, (Object)user);
                    operationLog.info((Object)("User " + user + " authenticated. Session: " + session));
                    return true;
                }
                catch (AuthenticationFailedException ex) {
                    return false;
                }
            }
        });
        s.addSessionListener(new SessionListener(){

            public void sessionException(Session session, Throwable t) {
                operationLog.error((Object)"Session exception", t);
            }
        });
        return s;
    }

    private List<? extends SubsystemFactory> creatSubsystemFactories() {
        SftpSubsystemFactory factory = new SftpSubsystemFactory.Builder().build();
        factory.setErrorStatusDataHandler(new SftpErrorStatusDataHandler(){
            private Set<Integer> subStatiForErrorLogging = new HashSet<Integer>(Arrays.asList(4, 8));

            public String resolveErrorMessage(SftpSubsystemEnvironment sftpSubsystem, int id, Throwable e, int subStatus, int cmd, Object ... args) {
                String message = super.resolveErrorMessage(sftpSubsystem, id, e, subStatus, cmd, args);
                User user = (User)sftpSubsystem.getSessionContext().getAttribute(USER_KEY);
                String logMessage = "user: " + user + ", id=" + id + ", substatus=" + subStatus + " (" + message + "), cmd=" + cmd + " (" + SftpConstants.getCommandMessageName((int)cmd) + "), args=" + Arrays.asList(args);
                if (this.subStatiForErrorLogging.contains(subStatus)) {
                    operationLog.error((Object)logMessage, e);
                } else {
                    operationLog.warn((Object)(logMessage + ": " + e));
                }
                return message;
            }
        });
        return Arrays.asList(factory);
    }

    public void stop() {
        if (this.server != null) {
            this.server.stop();
        }
        if (this.sshServer != null) {
            try {
                this.sshServer.stop();
            }
            catch (Exception ex) {
                throw CheckedExceptionTunnel.wrapIfNecessary((Exception)ex);
            }
        }
    }

    public DSSFileSystemView createFileSystemView(User user) throws FtpException {
        if (user instanceof FtpUser) {
            String sessionToken = ((FtpUser)user).getSessionToken();
            DSSFileSystemView fileSystemView = new DSSFileSystemView(sessionToken, this.openBisService, this.generalInfoService, this.v3api, this.pathResolverRegistry);
            Set<DSSFileSystemView> views = this.fileSystemViewsBySessionToken.get(sessionToken);
            if (views == null) {
                views = new HashSet<DSSFileSystemView>();
                this.fileSystemViewsBySessionToken.put(sessionToken, views);
            }
            views.add(fileSystemView);
            return fileSystemView;
        }
        throw new FtpException("Unsupported user type.");
    }

    public FileSystem createFileSystem(SessionContext session) throws IOException {
        User user = (User)session.getAttribute(USER_KEY);
        try {
            DSSFileSystemView fileSystemView = this.createFileSystemView(user);
            OpenBisFileSystemProvider fileSystemProvider = new OpenBisFileSystemProvider(fileSystemView);
            return new OpenBisFileSystem(fileSystemProvider, this.fileSystemViewsBySessionToken, this.userManager, user);
        }
        catch (FtpException ex) {
            throw new IOException(ex.getMessage(), ex);
        }
    }

    public Path getUserHomeDir(SessionContext session) throws IOException {
        return null;
    }

    private static final class KeystoreBasedKeyPairProvider
    extends AbstractKeyPairProvider {
        private final KeyPair[] keyPairs;

        private KeystoreBasedKeyPairProvider(FtpServerConfig config, Logger operationLog) {
            File keyStoreFile = config.getKeyStore();
            String keyStorePassword = config.getKeyStorePassword();
            String keyPassword = config.getKeyPassword();
            KeyStore keystore = this.loadKeystore(keyStoreFile, keyStorePassword);
            X509ExtendedKeyManager keyManager = this.getKeyManager(keystore, keyStorePassword, keyPassword);
            ArrayList<KeyPair> list = new ArrayList<KeyPair>();
            try {
                Enumeration<String> aliases = keystore.aliases();
                while (aliases.hasMoreElements()) {
                    String alias = aliases.nextElement();
                    if (!keystore.isKeyEntry(alias)) continue;
                    Certificate certificate = keystore.getCertificate(alias);
                    PublicKey publicKey = certificate.getPublicKey();
                    PrivateKey privateKey = keyManager.getPrivateKey(alias);
                    list.add(new KeyPair(publicKey, privateKey));
                }
                this.keyPairs = list.toArray(new KeyPair[list.size()]);
                operationLog.info((Object)(this.keyPairs.length + " key pairs loaded from keystore " + keyStoreFile));
            }
            catch (Exception ex) {
                throw CheckedExceptionTunnel.wrapIfNecessary((Exception)ex);
            }
        }

        public Iterable<KeyPair> loadKeys(SessionContext session) throws IOException, GeneralSecurityException {
            return Arrays.asList(this.keyPairs);
        }

        private KeyStore loadKeystore(File keyStoreFile, String keyStorePassword) {
            KeyStore keyStore;
            FileInputStream stream = null;
            try {
                KeyStore keystore = KeyStore.getInstance(KeyStore.getDefaultType());
                stream = new FileInputStream(keyStoreFile);
                keystore.load(stream, keyStorePassword.toCharArray());
                keyStore = keystore;
            }
            catch (Exception e) {
                try {
                    throw CheckedExceptionTunnel.wrapIfNecessary((Exception)e);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(stream);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((InputStream)stream);
            return keyStore;
        }

        private X509ExtendedKeyManager getKeyManager(KeyStore keystore, String keyStorePassword, String keyPassword) {
            try {
                String defaultAlgorithm = KeyManagerFactory.getDefaultAlgorithm();
                KeyManagerFactory factory = KeyManagerFactory.getInstance(defaultAlgorithm);
                char[] password = (keyPassword == null ? keyStorePassword : keyPassword).toCharArray();
                factory.init(keystore, password);
                KeyManager[] keyManagers = factory.getKeyManagers();
                if (keyManagers.length != 1) {
                    throw new ConfigurationFailureException("Only one key manager expected instead of " + keyManagers.length + ".");
                }
                KeyManager keyManager = keyManagers[0];
                if (!(keyManager instanceof X509ExtendedKeyManager)) {
                    throw new ConfigurationFailureException("Key manager is not of type " + X509ExtendedKeyManager.class.getSimpleName() + ": " + keyManager.getClass().getName());
                }
                return (X509ExtendedKeyManager)keyManager;
            }
            catch (Exception ex) {
                throw CheckedExceptionTunnel.wrapIfNecessary((Exception)ex);
            }
        }
    }

    private static class OpenBisFileAttributes
    implements PosixFileAttributes {
        private FileTime modifiedTime;
        private FileTime accessTime;
        private FileTime creationTime;
        private boolean regularFile;
        private boolean directory;
        private boolean symbolicLink;
        private long size;

        private OpenBisFileAttributes() {
        }

        @Override
        public FileTime lastModifiedTime() {
            return this.modifiedTime;
        }

        public void setModifiedTime(FileTime modifiedTime) {
            this.modifiedTime = modifiedTime;
        }

        @Override
        public FileTime lastAccessTime() {
            return this.accessTime;
        }

        public void setAccessTime(FileTime accessTime) {
            this.accessTime = accessTime;
        }

        @Override
        public FileTime creationTime() {
            return this.creationTime;
        }

        public void setCreationTime(FileTime creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public boolean isRegularFile() {
            return this.regularFile;
        }

        public void setRegularFile(boolean regularFile) {
            this.regularFile = regularFile;
        }

        @Override
        public boolean isDirectory() {
            return this.directory;
        }

        public void setDirectory(boolean directory) {
            this.directory = directory;
        }

        @Override
        public boolean isSymbolicLink() {
            return this.symbolicLink;
        }

        @Override
        public boolean isOther() {
            return !(this.regularFile || this.directory || this.symbolicLink);
        }

        @Override
        public long size() {
            return this.size;
        }

        public void setSize(long size) {
            this.size = size;
        }

        @Override
        public Object fileKey() {
            return null;
        }

        @Override
        public UserPrincipal owner() {
            return null;
        }

        @Override
        public GroupPrincipal group() {
            return null;
        }

        @Override
        public Set<PosixFilePermission> permissions() {
            return EnumSet.of(PosixFilePermission.OWNER_READ);
        }

        public String toString() {
            return this.modifiedTime + " " + (this.directory ? "DIR" : (this.regularFile ? "FILE" : "?")) + " " + this.size;
        }
    }

    private static class OpenBisFileSystemProvider
    extends FileSystemProvider {
        private DSSFileSystemView fileSystemView;

        public OpenBisFileSystemProvider(DSSFileSystemView fileSystemView) {
            this.fileSystemView = fileSystemView;
        }

        @Override
        public String getScheme() {
            return "openbis";
        }

        @Override
        public FileSystem newFileSystem(URI uri, Map<String, ?> env) throws IOException {
            return null;
        }

        @Override
        public FileSystem getFileSystem(URI uri) {
            return null;
        }

        @Override
        public Path getPath(URI uri) {
            return null;
        }

        @Override
        public SeekableByteChannel newByteChannel(Path path, Set<? extends OpenOption> options, FileAttribute<?> ... attrs) throws IOException {
            return null;
        }

        @Override
        public DirectoryStream<Path> newDirectoryStream(Path dir, DirectoryStream.Filter<? super Path> filter) throws IOException {
            FtpFile folder = this.getFile(dir);
            final ArrayList<Path> children = new ArrayList<Path>();
            for (FtpFile file : folder.listFiles()) {
                children.add(dir.getFileSystem().getPath(file.getAbsolutePath(), new String[0]));
            }
            return new DirectoryStream<Path>(){

                @Override
                public void close() throws IOException {
                }

                @Override
                public Iterator<Path> iterator() {
                    return children.iterator();
                }
            };
        }

        @Override
        public InputStream newInputStream(Path path, OpenOption ... options) throws IOException {
            throw new UnsupportedOperationException("Input streams not supported for " + path);
        }

        @Override
        public FileChannel newFileChannel(Path path, Set<? extends OpenOption> options, FileAttribute<?> ... attrs) throws IOException {
            FtpFile file = this.getFile(path);
            NonExistingFtpFile.throwFileNotFoundExceptionIfNonExistingFtpFile(file);
            if (!(file instanceof AbstractFtpFileWithContent)) {
                throw new UnsupportedOperationException("File channel not supported.");
            }
            return ((AbstractFtpFileWithContent)file).getFileChannel();
        }

        @Override
        public void createDirectory(Path dir, FileAttribute<?> ... attrs) throws IOException {
            throw new ReadOnlyFileSystemException();
        }

        @Override
        public void delete(Path path) throws IOException {
            throw new ReadOnlyFileSystemException();
        }

        @Override
        public void copy(Path source, Path target, CopyOption ... options) throws IOException {
            throw new ReadOnlyFileSystemException();
        }

        @Override
        public void move(Path source, Path target, CopyOption ... options) throws IOException {
            throw new ReadOnlyFileSystemException();
        }

        @Override
        public boolean isSameFile(Path path, Path path2) throws IOException {
            return path.toAbsolutePath().equals(path2.toAbsolutePath());
        }

        @Override
        public boolean isHidden(Path path) throws IOException {
            return false;
        }

        @Override
        public FileStore getFileStore(Path path) throws IOException {
            return null;
        }

        @Override
        public void checkAccess(Path path, AccessMode ... modes) throws IOException {
        }

        @Override
        public <V extends FileAttributeView> V getFileAttributeView(Path path, Class<V> type, LinkOption ... options) {
            return null;
        }

        @Override
        public <A extends BasicFileAttributes> A readAttributes(Path path, Class<A> type, LinkOption ... options) throws IOException {
            if (!(path instanceof OpenBisPath)) {
                throw new ProviderMismatchException();
            }
            OpenBisPath openBisPath = (OpenBisPath)((Object)path);
            OpenBisFileAttributes fileAttributes = openBisPath.getAttributes();
            if (fileAttributes == null) {
                fileAttributes = new OpenBisFileAttributes();
                FtpFile file = this.getFile(path);
                NonExistingFtpFile.throwFileNotFoundExceptionIfNonExistingFtpFile(file);
                FileTime lastModified = FileTime.fromMillis(file.getLastModified());
                fileAttributes.setModifiedTime(lastModified);
                fileAttributes.setCreationTime(lastModified);
                fileAttributes.setAccessTime(lastModified);
                fileAttributes.setSize(file.getSize());
                fileAttributes.setDirectory(file.isDirectory());
                fileAttributes.setRegularFile(file.isFile());
                openBisPath.setAttributes(fileAttributes);
            }
            return (A)fileAttributes;
        }

        private FtpFile getFile(Path path) {
            try {
                return this.fileSystemView.getFile(path.toString());
            }
            catch (FtpException e) {
                throw CheckedExceptionTunnel.wrapIfNecessary((Exception)((Object)e));
            }
        }

        @Override
        public Map<String, Object> readAttributes(Path path, String attributes, LinkOption ... options) throws IOException {
            return null;
        }

        @Override
        public void setAttribute(Path path, String attribute, Object value, LinkOption ... options) throws IOException {
            throw new ReadOnlyFileSystemException();
        }
    }

    private static class OpenBisPath
    extends BasePath<OpenBisPath, OpenBisFileSystem> {
        private OpenBisFileAttributes attributes;

        public OpenBisPath(OpenBisFileSystem fileSystem, String root, List<String> names) {
            super((BaseFileSystem)fileSystem, root, names);
        }

        public Path toRealPath(LinkOption ... options) throws IOException {
            BasePath absolutePath = this.toAbsolutePath();
            FileSystemProvider provider = ((OpenBisFileSystem)this.getFileSystem()).provider();
            provider.checkAccess((Path)absolutePath, new AccessMode[0]);
            return absolutePath;
        }

        public OpenBisFileAttributes getAttributes() {
            return this.attributes;
        }

        public void setAttributes(OpenBisFileAttributes attributes) {
            this.attributes = attributes;
        }
    }

    private static class OpenBisFileSystem
    extends BaseFileSystem<OpenBisPath> {
        private final FtpUserManager userManager;
        private final User user;
        private final DSSFileSystemView fileSystemView;
        private final Map<String, Set<DSSFileSystemView>> fileSystemViewsBySessionToken;
        private boolean open = true;

        public OpenBisFileSystem(OpenBisFileSystemProvider fileSystemProvider, Map<String, Set<DSSFileSystemView>> fileSystemViewsBySessionToken, FtpUserManager userManager, User user) {
            super((FileSystemProvider)fileSystemProvider);
            this.fileSystemViewsBySessionToken = fileSystemViewsBySessionToken;
            this.fileSystemView = fileSystemProvider.fileSystemView;
            this.userManager = userManager;
            this.user = user;
        }

        public boolean isReadOnly() {
            return true;
        }

        protected OpenBisPath create(String root, List<String> names) {
            return new OpenBisPath(this, root, names);
        }

        public void close() throws IOException {
            Set<DSSFileSystemView> views = this.fileSystemViewsBySessionToken.get(this.fileSystemView.getSessionToken());
            boolean noViews = false;
            if (views != null) {
                views.remove(this.fileSystemView);
                if (views.isEmpty()) {
                    this.fileSystemViewsBySessionToken.remove(this.fileSystemView.getSessionToken());
                    noViews = true;
                }
            }
            this.userManager.close(this.user, noViews);
            operationLog.info((Object)("File system closed for user " + this.user));
            this.open = false;
        }

        public boolean isOpen() {
            return this.open;
        }

        public Set<String> supportedFileAttributeViews() {
            return Collections.singleton("posix");
        }

        public UserPrincipalLookupService getUserPrincipalLookupService() {
            throw new UnsupportedOperationException();
        }
    }
}

