/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.server.ftp;

import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.properties.PropertyUtils;
import java.io.File;
import java.util.Properties;
import org.apache.log4j.Logger;

public class FtpServerConfig {
    private static final Logger operationLog = LogFactory.getLogger((LogCategory)LogCategory.OPERATION, FtpServerConfig.class);
    private static final String PREFIX = "ftp.server.";
    static final String ENABLE_KEY = "ftp.server.enable";
    static final String SFTP_PORT_KEY = "ftp.server.sftp-port";
    static final String LEGACY_FTP_PORT_KEY = "ftp.server.port";
    static final String FTP_PORT_KEY = "ftp.server.ftp-port";
    static final String USE_SSL_KEY = "ftp.server.use-ssl";
    static final String IMPLICIT_SSL_KEY = "ftp.server.implicit-ssl";
    static final String MAX_THREADS_KEY = "ftp.server.maxThreads";
    static final String ACTIVE_MODE_ENABLE_KEY = "ftp.server.activemode.enable";
    static final String ACTIVE_PORT_KEY = "ftp.server.activemode.port";
    static final String PASSIVE_MODE_PORT_RANGE_KEY = "ftp.server.passivemode.port.range";
    private static final int DEFAULT_ACTIVE_PORT = 2122;
    private static final boolean DEFAULT_USE_SSL = true;
    private static final boolean DEFAULT_IMPLICIT_SSL = false;
    private static final int DEFAULT_MAX_THREADS = 25;
    private static final String DEFAULT_PASSIVE_PORTS = "2130-2140";
    private boolean startServer;
    private int ftpPort;
    private boolean ftpMode;
    private boolean activeModeEnabled;
    private int activePort;
    private String passivePortsRange;
    private boolean useSSL;
    private boolean implicitSSL;
    private File keyStore;
    private String keyPassword;
    private String keyStorePassword;
    private int maxThreads;
    private boolean sftpMode;
    private int sftpPort;

    public FtpServerConfig(Properties props) {
        this.startServer = PropertyUtils.getBoolean((Properties)props, (String)ENABLE_KEY, (boolean)false);
        if (this.startServer) {
            this.initializeProperties(props);
        }
    }

    private void initializeProperties(Properties props) {
        this.sftpPort = PropertyUtils.getInt((Properties)props, (String)SFTP_PORT_KEY, (int)0);
        this.sftpMode = this.sftpPort > 0;
        this.ftpPort = PropertyUtils.getPosInt((Properties)props, (String)FTP_PORT_KEY, (int)0);
        if (this.ftpPort == 0) {
            this.ftpPort = PropertyUtils.getPosInt((Properties)props, (String)LEGACY_FTP_PORT_KEY, (int)0);
        }
        this.ftpMode = this.ftpPort > 0;
        this.useSSL = PropertyUtils.getBoolean((Properties)props, (String)USE_SSL_KEY, (boolean)true);
        if (this.sftpMode || this.useSSL) {
            this.initializeSSLProperties(props);
        }
        this.activeModeEnabled = PropertyUtils.getBoolean((Properties)props, (String)ACTIVE_MODE_ENABLE_KEY, (boolean)false);
        this.activePort = PropertyUtils.getPosInt((Properties)props, (String)ACTIVE_PORT_KEY, (int)2122);
        this.passivePortsRange = PropertyUtils.getProperty((Properties)props, (String)PASSIVE_MODE_PORT_RANGE_KEY, (String)DEFAULT_PASSIVE_PORTS);
        this.maxThreads = PropertyUtils.getPosInt((Properties)props, (String)MAX_THREADS_KEY, (int)25);
    }

    private void initializeSSLProperties(Properties props) {
        String keyStoreFileName = PropertyUtils.getMandatoryProperty((Properties)props, (String)"keystore.path");
        this.keyStore = new File(keyStoreFileName);
        this.keyStorePassword = PropertyUtils.getMandatoryProperty((Properties)props, (String)"keystore.password");
        this.keyPassword = PropertyUtils.getMandatoryProperty((Properties)props, (String)"keystore.key-password");
        this.implicitSSL = PropertyUtils.getBoolean((Properties)props, (String)IMPLICIT_SSL_KEY, (boolean)false);
    }

    public boolean isSftpMode() {
        return this.sftpMode;
    }

    public int getSftpPort() {
        return this.sftpPort;
    }

    public boolean isStartServer() {
        return this.startServer;
    }

    public boolean isFtpMode() {
        return this.ftpMode;
    }

    public int getFtpPort() {
        return this.ftpPort;
    }

    public boolean isUseSSL() {
        return this.useSSL;
    }

    public boolean isImplicitSSL() {
        return this.implicitSSL;
    }

    public File getKeyStore() {
        return this.keyStore;
    }

    public String getKeyPassword() {
        return this.keyPassword;
    }

    public String getKeyStorePassword() {
        return this.keyStorePassword;
    }

    public Integer getMaxThreads() {
        return this.maxThreads;
    }

    public void logStartupInfo() {
        if (this.ftpMode) {
            operationLog.info((Object)("FTP Server port: " + this.ftpPort));
            operationLog.info((Object)("FTP Server using SSL: " + this.useSSL));
            operationLog.info((Object)("FTP Server passive ports: " + this.passivePortsRange));
            operationLog.info((Object)("FTP Server enable active mode: " + this.activeModeEnabled));
            if (this.activeModeEnabled) {
                operationLog.info((Object)("FTP Server active mode port: " + this.activePort));
            }
        }
        if (this.sftpMode) {
            operationLog.info((Object)("SFTP Server port: " + this.sftpPort));
        }
    }

    public boolean isActiveModeEnabled() {
        return this.activeModeEnabled;
    }

    public int getActiveLocalPort() {
        return this.activePort;
    }

    public String getPassivePortsRange() {
        return this.passivePortsRange;
    }
}

