/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.server.ftp;

import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.openbis.dss.generic.server.ftp.FtpUser;
import ch.systemsx.cisd.openbis.generic.shared.IServiceForDataStoreServer;
import ch.systemsx.cisd.openbis.generic.shared.dto.SessionContextDTO;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.ftpserver.ftplet.Authentication;
import org.apache.ftpserver.ftplet.AuthenticationFailedException;
import org.apache.ftpserver.ftplet.FtpException;
import org.apache.ftpserver.ftplet.User;
import org.apache.ftpserver.ftplet.UserManager;
import org.apache.ftpserver.usermanager.UsernamePasswordAuthentication;
import org.apache.log4j.Logger;

public class FtpUserManager
implements UserManager {
    private static final Logger operationLog = LogFactory.getLogger((LogCategory)LogCategory.OPERATION, FtpUserManager.class);
    private final IServiceForDataStoreServer service;
    private final Map<String, String> sessionTokensByUser = Collections.synchronizedMap(new HashMap());

    public FtpUserManager(IServiceForDataStoreServer service) {
        this.service = service;
    }

    public User authenticate(Authentication authentication) throws AuthenticationFailedException {
        if (authentication instanceof UsernamePasswordAuthentication) {
            SessionContextDTO session;
            String password;
            UsernamePasswordAuthentication upa = (UsernamePasswordAuthentication)authentication;
            String user = upa.getUsername();
            String key = String.format("%s:%s", user, password = upa.getPassword());
            String sessionToken = this.getSessionToken(key, user, password);
            if (sessionToken != null) {
                session = this.service.tryGetSession(sessionToken);
                if (session == null) {
                    sessionToken = null;
                } else {
                    user = session.getUserPersonObject().getUserId();
                    operationLog.info((Object)("User '" + user + "' authenticated via session token"));
                    sessionToken = session.getSessionToken();
                }
            }
            if (sessionToken == null) {
                session = this.service.tryAuthenticate(user, password);
                sessionToken = session == null ? null : session.getSessionToken();
                this.sessionTokensByUser.put(key, sessionToken);
            }
            if (sessionToken != null) {
                return new FtpUser(user, sessionToken);
            }
        } else {
            operationLog.warn((Object)("Unsupported authentication type :" + authentication.getClass()));
        }
        throw new AuthenticationFailedException();
    }

    public void close(User user, boolean noViews) {
        String key = this.getSessionKey(user);
        if (key != null) {
            String sessionToken = this.sessionTokensByUser.remove(key);
            operationLog.info((Object)("Session token " + sessionToken + " removed."));
            if (noViews) {
                this.service.logout(sessionToken);
                operationLog.info((Object)("Log out session " + sessionToken + " because last file system session view for this session has been closed."));
            }
        }
    }

    private String getSessionKey(User user) {
        if (user instanceof FtpUser) {
            FtpUser ftpUser = (FtpUser)user;
            String sessionToken = ftpUser.getSessionToken();
            for (Map.Entry<String, String> entry : this.sessionTokensByUser.entrySet()) {
                if (!sessionToken.equals(entry.getValue())) continue;
                return entry.getKey();
            }
        }
        return null;
    }

    private String getSessionToken(String key, String user, String password) {
        if ("?".equals(user)) {
            return password;
        }
        return this.sessionTokensByUser.get(key);
    }

    public void delete(String arg0) throws FtpException {
        throw new UnsupportedOperationException();
    }

    public boolean doesExist(String arg0) throws FtpException {
        return false;
    }

    public String getAdminName() throws FtpException {
        throw new UnsupportedOperationException();
    }

    public String[] getAllUserNames() throws FtpException {
        throw new UnsupportedOperationException();
    }

    public User getUserByName(String userName) throws FtpException {
        return new FtpUser(userName, null);
    }

    public boolean isAdmin(String arg0) throws FtpException {
        return false;
    }

    public void save(User arg0) throws FtpException {
        throw new UnsupportedOperationException();
    }
}

