/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.server.ftp;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import org.apache.ftpserver.ftplet.FtpFile;

public class NonExistingFtpFile
implements FtpFile {
    private final String path;
    private final String errorMsgOrNull;

    public static void throwFileNotFoundExceptionIfNonExistingFtpFile(FtpFile file) throws FileNotFoundException {
        if (file instanceof NonExistingFtpFile) {
            throw new FileNotFoundException("Unknown file: " + file);
        }
    }

    public NonExistingFtpFile(String path, String errorMsgOrNull) {
        this.path = path;
        this.errorMsgOrNull = errorMsgOrNull;
    }

    public String getErrorMessage() {
        return this.errorMsgOrNull;
    }

    public String getAbsolutePath() {
        return this.path;
    }

    public String getName() {
        return FilenameUtils.getName((String)this.path);
    }

    public boolean isHidden() {
        return false;
    }

    public boolean isDirectory() {
        return false;
    }

    public boolean isFile() {
        return false;
    }

    public boolean doesExist() {
        return false;
    }

    public boolean isReadable() {
        return false;
    }

    public boolean isWritable() {
        return false;
    }

    public boolean isRemovable() {
        return false;
    }

    public String getOwnerName() {
        return "UNKNOWN";
    }

    public String getGroupName() {
        return "UNKNOWN";
    }

    public int getLinkCount() {
        return 0;
    }

    public long getLastModified() {
        return 0L;
    }

    public boolean setLastModified(long time) {
        return false;
    }

    public long getSize() {
        return 0L;
    }

    public boolean mkdir() {
        return false;
    }

    public boolean delete() {
        return false;
    }

    public boolean move(FtpFile destination) {
        return false;
    }

    public List<FtpFile> listFiles() {
        return Collections.emptyList();
    }

    public OutputStream createOutputStream(long offset) throws IOException {
        if (this.errorMsgOrNull != null) {
            throw new IOException("File '" + this.path + "' does not exist (" + this.errorMsgOrNull + ".");
        }
        throw new IOException("File '" + this.path + "' does not exist.");
    }

    public InputStream createInputStream(long offset) throws IOException {
        if (this.errorMsgOrNull != null) {
            throw new IOException("File '" + this.path + "' does not exist (" + this.errorMsgOrNull + ".");
        }
        throw new IOException("File '" + this.path + "' does not exist.");
    }

    public String toString() {
        return this.path + (this.errorMsgOrNull == null ? "" : " (Error: " + this.errorMsgOrNull + ")");
    }
}

