/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.server.ftp.resolver;

import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import org.apache.ftpserver.ftplet.FtpFile;
import org.apache.log4j.Logger;

public abstract class AbstractFtpFile
implements FtpFile {
    private static final Logger operationLog = LogFactory.getLogger((LogCategory)LogCategory.OPERATION, AbstractFtpFile.class);
    protected final String absolutePath;
    private long lastModified;

    public AbstractFtpFile(String absolutePath) {
        this.absolutePath = absolutePath;
    }

    public final List<FtpFile> listFiles() {
        try {
            return this.unsafeListFiles();
        }
        catch (RuntimeException rex) {
            operationLog.error((Object)("Error while listing files for FTP :" + rex.getMessage()), (Throwable)rex);
            throw rex;
        }
    }

    public abstract List<FtpFile> unsafeListFiles() throws RuntimeException;

    public boolean doesExist() {
        return true;
    }

    public String getAbsolutePath() {
        return this.absolutePath;
    }

    public String getName() {
        return new File(this.absolutePath).getName();
    }

    public String getOwnerName() {
        return "dss";
    }

    public String getGroupName() {
        return "dss";
    }

    public boolean isHidden() {
        return false;
    }

    public boolean isReadable() {
        return true;
    }

    public boolean isRemovable() {
        return false;
    }

    public boolean isWritable() {
        return false;
    }

    public boolean setLastModified(long arg0) {
        this.lastModified = arg0;
        return true;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public OutputStream createOutputStream(long arg0) throws IOException {
        return null;
    }

    public boolean delete() {
        return false;
    }

    public boolean mkdir() {
        return false;
    }

    public boolean move(FtpFile arg0) {
        return false;
    }

    public int getLinkCount() {
        return 0;
    }
}

