/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.server.ftp.resolver;

import ch.systemsx.cisd.openbis.dss.generic.server.ftp.FtpPathResolverContext;
import ch.systemsx.cisd.openbis.dss.generic.server.ftp.IFtpPathResolver;
import ch.systemsx.cisd.openbis.dss.generic.server.ftp.resolver.AbstractFtpFolder;
import ch.systemsx.cisd.openbis.dss.generic.server.ftp.resolver.IExperimentChildrenLister;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Experiment;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.ftpserver.ftplet.FtpFile;

public class ExperimentFolderResolver
implements IFtpPathResolver {
    private final IExperimentChildrenLister childLister;

    public ExperimentFolderResolver(IExperimentChildrenLister childLister) {
        this.childLister = childLister;
    }

    @Override
    public boolean canResolve(String path) {
        int nestedLevels = StringUtils.countMatches((CharSequence)path, (CharSequence)"/");
        return nestedLevels == 3;
    }

    @Override
    public FtpFile resolve(final String path, final FtpPathResolverContext resolverContext) {
        final Experiment experiment = resolverContext.getExperiment(path);
        AbstractFtpFolder file = new AbstractFtpFolder(path){

            @Override
            public List<FtpFile> unsafeListFiles() {
                if (experiment == null) {
                    return Collections.emptyList();
                }
                return ExperimentFolderResolver.this.childLister.listExperimentChildrenPaths(experiment, path, resolverContext);
            }
        };
        if (experiment != null) {
            file.setLastModified(experiment.getModificationDate().getTime());
        }
        return file;
    }
}

