/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.server.ftp.resolver;

import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.openbis.dss.generic.server.ftp.FtpPathResolverContext;
import ch.systemsx.cisd.openbis.dss.generic.server.ftp.IFtpPathResolver;
import ch.systemsx.cisd.openbis.dss.generic.server.ftp.IFtpPathResolverRegistry;
import ch.systemsx.cisd.openbis.dss.generic.server.ftp.resolver.AbstractFtpFolder;
import ch.systemsx.cisd.openbis.generic.shared.IServiceForDataStoreServer;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Experiment;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ExperimentFetchOptions;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Project;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ProjectIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ProjectIdentifierFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.ftpserver.ftplet.FtpFile;

public class ProjectFolderResolver
implements IFtpPathResolver {
    @Override
    public boolean canResolve(String path) {
        int nestedLevels = StringUtils.countMatches((CharSequence)path, (CharSequence)"/");
        return nestedLevels == 2;
    }

    @Override
    public FtpFile resolve(final String path, final FtpPathResolverContext resolverContext) {
        String sessionToken;
        ProjectIdentifier identifier = this.parseProjectIdentifier(path);
        IServiceForDataStoreServer service = resolverContext.getService();
        Project project = service.tryGetProject(sessionToken = resolverContext.getSessionToken(), identifier);
        if (project == null) {
            throw new UserFailureException("Unknown project '" + identifier + "'.");
        }
        AbstractFtpFolder file = new AbstractFtpFolder(path){

            @Override
            public List<FtpFile> unsafeListFiles() {
                List experiments = ProjectFolderResolver.this.listExperiments(path, resolverContext);
                ArrayList<FtpFile> result = new ArrayList<FtpFile>();
                for (Experiment experiment : experiments) {
                    String childPath = path + "/" + experiment.getCode();
                    IFtpPathResolverRegistry resolverRegistry = resolverContext.getResolverRegistry();
                    FtpFile childFile = resolverRegistry.resolve(childPath, resolverContext);
                    result.add(childFile);
                }
                return result;
            }
        };
        file.setLastModified(project.getModificationDate().getTime());
        return file;
    }

    private List<Experiment> listExperiments(String projectIdentifier, FtpPathResolverContext context) {
        ProjectIdentifier identifier = this.parseProjectIdentifier(projectIdentifier);
        IServiceForDataStoreServer service = context.getService();
        String sessionToken = context.getSessionToken();
        return service.listExperimentsForProjects(sessionToken, Collections.singletonList(identifier), new ExperimentFetchOptions());
    }

    private ProjectIdentifier parseProjectIdentifier(String projectIdentifier) {
        return new ProjectIdentifierFactory(projectIdentifier).createIdentifier();
    }
}

