/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.server.ftp.resolver;

import ch.systemsx.cisd.openbis.dss.generic.server.ftp.FtpPathResolverContext;
import ch.systemsx.cisd.openbis.dss.generic.server.ftp.IFtpPathResolver;
import ch.systemsx.cisd.openbis.dss.generic.server.ftp.resolver.AbstractFtpFolder;
import ch.systemsx.cisd.openbis.generic.shared.IServiceForDataStoreServer;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Project;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;
import org.apache.ftpserver.ftplet.FtpFile;

public class RootFolderResolver
implements IFtpPathResolver {
    @Override
    public boolean canResolve(String path) {
        return "/".equals(path);
    }

    @Override
    public FtpFile resolve(String path, final FtpPathResolverContext resolverContext) {
        return new AbstractFtpFolder(path){

            @Override
            public List<FtpFile> unsafeListFiles() {
                List<Project> projects = this.listProjects(resolverContext);
                ArrayList<FtpFile> result = new ArrayList<FtpFile>();
                TreeSet<String> spacesSeen = new TreeSet<String>();
                for (Project project : projects) {
                    String spaceCode = project.getSpace().getCode();
                    spacesSeen.add(spaceCode);
                }
                for (String spaceCode : spacesSeen) {
                    String childPath = "/" + spaceCode;
                    FtpFile child = resolverContext.getResolverRegistry().resolve(childPath, resolverContext);
                    if (child == null) continue;
                    result.add(child);
                }
                return result;
            }

            private List<Project> listProjects(FtpPathResolverContext context) {
                IServiceForDataStoreServer service = context.getService();
                String sessionToken = context.getSessionToken();
                List projects = service.listProjects(sessionToken);
                return projects;
            }
        };
    }
}

