/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.server.ftp.resolver;

import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.openbis.dss.generic.server.ftp.FtpPathResolverContext;
import ch.systemsx.cisd.openbis.dss.generic.server.ftp.IFtpPathResolver;
import ch.systemsx.cisd.openbis.dss.generic.server.ftp.resolver.AbstractFtpFolder;
import ch.systemsx.cisd.openbis.generic.shared.IServiceForDataStoreServer;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Project;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Space;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SpaceIdentifier;
import java.util.ArrayList;
import java.util.List;
import org.apache.ftpserver.ftplet.FtpFile;

public class SpaceFolderResolver
implements IFtpPathResolver {
    @Override
    public boolean canResolve(String path) {
        return false == this.removeStartingSlash(path).contains("/");
    }

    @Override
    public FtpFile resolve(final String path, final FtpPathResolverContext resolverContext) {
        final String spaceCode = this.removeStartingSlash(path);
        String sessionToken = resolverContext.getSessionToken();
        IServiceForDataStoreServer service = resolverContext.getService();
        Space space = service.tryGetSpace(sessionToken, new SpaceIdentifier(spaceCode));
        if (space == null) {
            throw new UserFailureException("Unknown space '" + spaceCode + "'.");
        }
        AbstractFtpFolder file = new AbstractFtpFolder(path){

            @Override
            public List<FtpFile> unsafeListFiles() {
                List projects = SpaceFolderResolver.this.listProjects(resolverContext);
                ArrayList<FtpFile> result = new ArrayList<FtpFile>();
                ArrayList<String> childProjects = new ArrayList<String>();
                for (Project project : projects) {
                    String projectSpaceCode = project.getSpace().getCode();
                    if (!projectSpaceCode.equals(spaceCode)) continue;
                    childProjects.add(project.getCode());
                }
                for (String childProject : childProjects) {
                    String childPath = path + "/" + childProject;
                    FtpFile childFile = resolverContext.getResolverRegistry().resolve(childPath, resolverContext);
                    result.add(childFile);
                }
                return result;
            }
        };
        file.setLastModified(space.getModificationDate().getTime());
        return file;
    }

    private List<Project> listProjects(FtpPathResolverContext context) {
        IServiceForDataStoreServer service = context.getService();
        String sessionToken = context.getSessionToken();
        List projects = service.listProjects(sessionToken);
        return projects;
    }

    private String removeStartingSlash(String path) {
        if (path.startsWith("/")) {
            return path.substring(1);
        }
        return path;
    }
}

