/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.server.ftp.resolver;

import ch.rinn.restrictions.Private;
import ch.systemsx.cisd.common.exceptions.ConfigurationFailureException;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.server.ISessionTokenProvider;
import ch.systemsx.cisd.common.string.Template;
import ch.systemsx.cisd.openbis.common.io.hierarchical_content.IHierarchicalContentNodeFilter;
import ch.systemsx.cisd.openbis.common.io.hierarchical_content.api.IHierarchicalContent;
import ch.systemsx.cisd.openbis.common.io.hierarchical_content.api.IHierarchicalContentNode;
import ch.systemsx.cisd.openbis.dss.generic.server.ftp.Cache;
import ch.systemsx.cisd.openbis.dss.generic.server.ftp.FtpFileFactory;
import ch.systemsx.cisd.openbis.dss.generic.server.ftp.FtpPathResolverConfig;
import ch.systemsx.cisd.openbis.dss.generic.server.ftp.FtpPathResolverContext;
import ch.systemsx.cisd.openbis.dss.generic.server.ftp.FtpPathResolverRegistry;
import ch.systemsx.cisd.openbis.dss.generic.server.ftp.IFtpPathResolver;
import ch.systemsx.cisd.openbis.dss.generic.server.ftp.resolver.AbstractFtpFolder;
import ch.systemsx.cisd.openbis.dss.generic.server.ftp.resolver.FtpFileEvaluationContext;
import ch.systemsx.cisd.openbis.dss.generic.server.ftp.resolver.IExperimentChildrenLister;
import ch.systemsx.cisd.openbis.dss.generic.shared.IHierarchicalContentProvider;
import ch.systemsx.cisd.openbis.dss.generic.shared.ServiceProvider;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.DataSet;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.AbstractExternalData;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Experiment;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.ftpserver.ftplet.FtpFile;
import org.apache.log4j.Logger;

public class TemplateBasedDataSetResourceResolver
implements IFtpPathResolver,
IExperimentChildrenLister {
    private static final String DATA_SET_CODE_VARNAME = "dataSetCode";
    private static final String DATA_SET_TYPE_VARNAME = "dataSetType";
    private static final String DATA_SET_DATE_VARNAME = "dataSetDate";
    private static final String FILE_NAME_VARNAME = "fileName";
    private static final String DISAMBIGUATION_VARNAME = "disambiguation";
    private static final String DATA_SET_DATE_FORMAT = "yyyy-MM-dd-HH-mm";
    private static final String PARENT_PREFIX = "PARENT-";
    private static final String CHILD_PREFIX = "CHILD-";
    private static final Logger operationLog = LogFactory.getLogger((LogCategory)LogCategory.OPERATION, TemplateBasedDataSetResourceResolver.class);
    private final Template template;
    private final Map<String, DataSetTypeConfig> dataSetTypeConfigs;
    private final DataSetTypeConfig defaultDSTypeConfig;
    private boolean showParentsAndChildren;
    private boolean fileNamePresent;
    private IHierarchicalContentProvider contentProvider;

    public TemplateBasedDataSetResourceResolver(FtpPathResolverConfig resolverConfig) {
        this.template = new Template(resolverConfig.getDataSetDisplayTemplate());
        this.showParentsAndChildren = resolverConfig.isShowParentsAndChildren();
        this.fileNamePresent = this.template.getPlaceholderNames().contains(FILE_NAME_VARNAME);
        if (this.fileNamePresent && this.showParentsAndChildren) {
            throw new ConfigurationFailureException("Template contains file name variable and the flag to show parents/children data sets is set.");
        }
        this.dataSetTypeConfigs = this.initializeDataSetTypeConfigs(resolverConfig);
        this.defaultDSTypeConfig = new DataSetTypeConfig();
    }

    void setContentProvider(IHierarchicalContentProvider contentProvider) {
        this.contentProvider = contentProvider;
    }

    @Override
    public boolean canResolve(String path) {
        int nestedLevels = StringUtils.countMatches((CharSequence)path, (CharSequence)"/");
        return nestedLevels >= 4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FtpFile resolve(String path, FtpPathResolverContext resolverContext) {
        String experimentId = this.extractExperimentIdFromPath(path);
        Experiment experiment = this.tryGetExperiment(experimentId, resolverContext);
        if (experiment == null) {
            return FtpPathResolverRegistry.getNonExistingFile(path, "Unknown experiment '" + experimentId + "'.");
        }
        List<AbstractExternalData> dataSets = resolverContext.getDataSets(experiment);
        if (this.fileNamePresent) {
            try (FtpFileEvaluationContext evalContext = this.evaluateDataSetPaths(resolverContext, dataSets);){
                FtpFile ftpFile = this.extractMatchingFile(path, experimentId, resolverContext.getCache(), evalContext);
                return ftpFile;
            }
        }
        return this.resolve(path, resolverContext, dataSets);
    }

    private FtpFile resolve(String path, FtpPathResolverContext resolverContext, List<AbstractExternalData> dataSets) {
        Object[] pathElements = StringUtils.splitByWholeSeparatorPreserveAllTokens((String)path, (String)"/");
        FtpFile result = null;
        for (int i = 4; i < pathElements.length; ++i) {
            String dataSetPathElement = pathElements[i];
            if (result == null) {
                AbstractExternalData dataSet = this.tryToFindDataSet(dataSets, dataSetPathElement);
                if (dataSet == null) {
                    return FtpPathResolverRegistry.getNonExistingFile(path, "No match found for path element '" + dataSetPathElement + "'.");
                }
                String subPath = StringUtils.join((Object[])pathElements, (String)"/", (int)0, (int)(i + 1));
                result = new DataSetFtpFolder(subPath, dataSet, resolverContext);
                continue;
            }
            List files = result.listFiles();
            FtpFile matchingFile = null;
            for (FtpFile file : files) {
                if (!dataSetPathElement.equals(file.getName())) continue;
                matchingFile = file;
                break;
            }
            if (matchingFile == null) {
                return FtpPathResolverRegistry.getNonExistingFile(path, "No match found for path element '" + dataSetPathElement + "'.");
            }
            result = matchingFile;
        }
        return result;
    }

    private AbstractExternalData tryToFindDataSet(List<AbstractExternalData> dataSets, String dataSetPathElement) {
        for (int disambiguationIdx = 0; disambiguationIdx < dataSets.size(); ++disambiguationIdx) {
            String disambiguationVar = this.computeDisambiguation(disambiguationIdx);
            AbstractExternalData dataSet = dataSets.get(disambiguationIdx);
            String pathElement = this.evaluateTemplate(dataSet, null, disambiguationVar);
            if (!dataSetPathElement.equals(pathElement)) continue;
            return dataSet;
        }
        return null;
    }

    private FtpFile extractMatchingFile(String path, String experimentId, Cache cache, FtpFileEvaluationContext evalContext) {
        FtpFileEvaluationContext.EvaluatedElement matchingElement = this.tryFindMatchingEvalElement(path, experimentId, evalContext);
        if (matchingElement == null) {
            return FtpPathResolverRegistry.getNonExistingFile(path, "Resource '" + path + "' for experiment " + experimentId + " does not exist.");
        }
        String pathInDataSet = this.extractPathInDataSet(path);
        String hierarchicalNodePath = this.constructHierarchicalNodePath(matchingElement.pathInDataSet, pathInDataSet);
        AbstractExternalData dataSet = matchingElement.dataSet;
        IHierarchicalContentNodeFilter fileFilter = this.getFileFilter(dataSet);
        IHierarchicalContent content = evalContext.getHierarchicalContent(dataSet, true);
        IHierarchicalContentNode contentNodeOrNull = content.tryGetNode(hierarchicalNodePath);
        if (contentNodeOrNull != null && fileFilter.accept(contentNodeOrNull)) {
            return FtpFileFactory.createFtpFile(dataSet.getCode(), path, contentNodeOrNull, content, fileFilter, dataSet.getModificationDate().getTime(), cache);
        }
        return FtpPathResolverRegistry.getNonExistingFile(path, "Resource '" + hierarchicalNodePath + "' does not exist.");
    }

    private FtpFileEvaluationContext.EvaluatedElement tryFindMatchingEvalElement(String path, String experimentId, FtpFileEvaluationContext evalContext) {
        String pathWithEndSlash = path + "/";
        for (FtpFileEvaluationContext.EvaluatedElement evalElement : evalContext.getEvalElements()) {
            String fullEvaluatedPath = experimentId + "/" + evalElement.evaluatedTemplate + "/";
            if (!pathWithEndSlash.startsWith(fullEvaluatedPath)) continue;
            return evalElement;
        }
        return null;
    }

    private String extractPathInDataSet(String path) {
        Object[] levels = StringUtils.split((String)path, (String)"/");
        if (levels.length > 4) {
            return StringUtils.join((Object[])levels, (String)"/", (int)4, (int)levels.length);
        }
        return "";
    }

    private String constructHierarchicalNodePath(String relativePath, String pathInDataSet) {
        String result = relativePath;
        if (!StringUtils.isBlank((CharSequence)pathInDataSet)) {
            result = StringUtils.isBlank((CharSequence)relativePath) ? pathInDataSet : result + "/" + pathInDataSet;
        }
        return result;
    }

    private Experiment tryGetExperiment(String experimentId, FtpPathResolverContext context) {
        try {
            return context.getExperiment(experimentId);
        }
        catch (Throwable t) {
            operationLog.warn((Object)("Failed to get experiment with identifier :" + experimentId), t);
            return null;
        }
    }

    private String extractExperimentIdFromPath(String path) {
        Object[] levels = StringUtils.split((String)path, (String)"/");
        String experimentId = "/" + StringUtils.join((Object[])levels, (String)"/", (int)0, (int)3);
        return experimentId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<FtpFile> listExperimentChildrenPaths(Experiment experiment, String parentPath, FtpPathResolverContext context) {
        List<AbstractExternalData> dataSets = context.getDataSets(experiment);
        try (FtpFileEvaluationContext evalContext = this.evaluateDataSetPaths(context, dataSets);){
            List<FtpFile> list = this.createFtpFilesFromEvaluationResult(context, parentPath, evalContext);
            return list;
        }
    }

    private List<FtpFile> createFtpFilesFromEvaluationResult(FtpPathResolverContext context, String parentPath, FtpFileEvaluationContext evalResult) {
        ArrayList<FtpFile> result = new ArrayList<FtpFile>();
        Cache cache = context.getCache();
        for (FtpFileEvaluationContext.EvaluatedElement evalElement : evalResult.getEvalElements()) {
            AbstractExternalData dataSet = evalElement.dataSet;
            IHierarchicalContentNodeFilter fileFilter = this.getFileFilter(dataSet);
            if (!fileFilter.accept(evalElement.contentNode)) continue;
            String childPath = parentPath + "/" + evalElement.evaluatedTemplate;
            String dataSetCode = dataSet.getCode();
            IHierarchicalContent content = evalResult.getHierarchicalContent(dataSet, false);
            FtpFile childFtpFile = FtpFileFactory.createFtpFile(dataSetCode, childPath, evalElement.contentNode, content, fileFilter, dataSet.getModificationDate().getTime(), cache);
            result.add(childFtpFile);
        }
        return result;
    }

    private FtpFileEvaluationContext evaluateDataSetPaths(ISessionTokenProvider sessionTokenProvider, List<AbstractExternalData> dataSets) {
        FtpFileEvaluationContext evalContext = this.createFtpFileEvaluationContext(sessionTokenProvider);
        for (int disambiguationIdx = 0; disambiguationIdx < dataSets.size(); ++disambiguationIdx) {
            AbstractExternalData dataSet = dataSets.get(disambiguationIdx);
            try {
                IHierarchicalContent hierarchicalContent = evalContext.getHierarchicalContent(dataSet, false);
                IHierarchicalContentNode rootNode = this.getDataSetFileListRoot(dataSet, hierarchicalContent);
                List<FtpFileEvaluationContext.EvaluatedElement> paths = this.evaluateDataSetPaths(dataSet, rootNode, disambiguationIdx);
                evalContext.addEvaluatedElements(paths);
                continue;
            }
            catch (Throwable t) {
                operationLog.warn((Object)("Failed to evaluate data set paths for dataset " + dataSet.getCode() + ": " + t.getMessage()));
            }
        }
        return evalContext;
    }

    private List<FtpFileEvaluationContext.EvaluatedElement> evaluateDataSetPaths(AbstractExternalData dataSet, IHierarchicalContentNode rootNode, int disambiguationIndex) {
        ArrayList<FtpFileEvaluationContext.EvaluatedElement> result = new ArrayList<FtpFileEvaluationContext.EvaluatedElement>();
        String disambiguationVar = this.computeDisambiguation(disambiguationIndex);
        for (IHierarchicalContentNode fileNode : this.getFileNamesRequiredByTemplate(rootNode)) {
            FtpFileEvaluationContext.EvaluatedElement evalElement = new FtpFileEvaluationContext.EvaluatedElement();
            evalElement.dataSet = dataSet;
            evalElement.pathInDataSet = fileNode.getRelativePath();
            evalElement.evaluatedTemplate = this.evaluateTemplate(dataSet, fileNode.getName(), disambiguationVar);
            evalElement.contentNode = fileNode;
            result.add(evalElement);
        }
        return result;
    }

    private IHierarchicalContentNode getDataSetFileListRoot(AbstractExternalData dataSet, IHierarchicalContent hierachicalContent) {
        String fileListSubPathOrNull = this.getFileListSubPath(dataSet);
        if (!StringUtils.isBlank((CharSequence)fileListSubPathOrNull)) {
            List matchingNodes = hierachicalContent.listMatchingNodes(fileListSubPathOrNull);
            if (!matchingNodes.isEmpty()) {
                if (matchingNodes.size() == 1) {
                    return (IHierarchicalContentNode)matchingNodes.get(0);
                }
                String message = String.format("Multiple nodes in dataset '%s' match pattern '%s'. Will use data set root for file listing.", dataSet.getCode(), fileListSubPathOrNull);
                operationLog.warn((Object)message);
            } else {
                String message = String.format("No nodes in dataset '%s' match pattern '%s'. Will use data set root for file listings.", dataSet.getCode(), fileListSubPathOrNull);
                operationLog.warn((Object)message);
            }
        }
        return hierachicalContent.getRootNode();
    }

    private String computeDisambiguation(int disambiguationIdx) {
        int number = 10 + disambiguationIdx;
        return Integer.toString(number, 36).toUpperCase();
    }

    private List<IHierarchicalContentNode> getFileNamesRequiredByTemplate(IHierarchicalContentNode rootNode) {
        if (this.fileNamePresent && rootNode.isDirectory()) {
            return rootNode.getChildNodes();
        }
        return Collections.singletonList(rootNode);
    }

    private String evaluateTemplate(AbstractExternalData dataSet, String fileName, String disambiguation) {
        Template eval = this.template.createFreshCopy();
        eval.attemptToBind(DATA_SET_CODE_VARNAME, dataSet.getCode());
        eval.attemptToBind(DATA_SET_TYPE_VARNAME, dataSet.getDataSetType().getCode());
        String dataSetDate = TemplateBasedDataSetResourceResolver.extractDateValue(dataSet.getRegistrationDate());
        eval.attemptToBind(DATA_SET_DATE_VARNAME, dataSetDate);
        if (fileName != null) {
            eval.attemptToBind(FILE_NAME_VARNAME, fileName);
        }
        eval.attemptToBind(DISAMBIGUATION_VARNAME, disambiguation);
        return eval.createText();
    }

    @Private
    static String extractDateValue(Date dataSetDate) {
        return DateFormatUtils.format((Date)dataSetDate, (String)DATA_SET_DATE_FORMAT);
    }

    private Map<String, DataSetTypeConfig> initializeDataSetTypeConfigs(FtpPathResolverConfig resolverConfig) {
        HashMap<String, DataSetTypeConfig> result = new HashMap<String, DataSetTypeConfig>();
        Map<String, String> fileListSubPaths = resolverConfig.getFileListSubPaths();
        Map<String, String> fileListFilters = resolverConfig.getFileListFilters();
        for (Map.Entry<String, String> subPathEntry : fileListSubPaths.entrySet()) {
            DataSetTypeConfig dsConfig = new DataSetTypeConfig();
            dsConfig.fileListSubPath = subPathEntry.getValue();
            result.put(subPathEntry.getKey(), dsConfig);
        }
        for (Map.Entry<String, String> filterEntry : fileListFilters.entrySet()) {
            String dataSetType = filterEntry.getKey();
            String fileFilterPattern = filterEntry.getValue();
            DataSetTypeConfig dsConfig = (DataSetTypeConfig)result.get(dataSetType);
            if (dsConfig == null) {
                dsConfig = new DataSetTypeConfig();
            }
            dsConfig.fileFilter = this.createFilter(fileFilterPattern);
            result.put(dataSetType, dsConfig);
        }
        return result;
    }

    private IHierarchicalContentNodeFilter createFilter(final String fileFilterPattern) {
        return new IHierarchicalContentNodeFilter(){
            private final Pattern compiledPattern;
            {
                this.compiledPattern = Pattern.compile(fileFilterPattern);
            }

            public boolean accept(IHierarchicalContentNode node) {
                if (node.isDirectory()) {
                    return true;
                }
                return this.compiledPattern.matcher(node.getName()).matches();
            }
        };
    }

    private DataSetTypeConfig getDataSetTypeConfig(AbstractExternalData dataSet) {
        String dataSetType = dataSet.getDataSetType().getCode();
        DataSetTypeConfig dsConfig = this.dataSetTypeConfigs.get(dataSetType);
        if (dsConfig != null) {
            return dsConfig;
        }
        return this.defaultDSTypeConfig;
    }

    private IHierarchicalContentNodeFilter getFileFilter(AbstractExternalData dataSet) {
        return this.getDataSetTypeConfig((AbstractExternalData)dataSet).fileFilter;
    }

    private String getFileListSubPath(AbstractExternalData dataSet) {
        return this.getDataSetTypeConfig((AbstractExternalData)dataSet).fileListSubPath;
    }

    private FtpFileEvaluationContext createFtpFileEvaluationContext(ISessionTokenProvider sessionTokenProvider) {
        return new FtpFileEvaluationContext(this.getContentProvider(sessionTokenProvider));
    }

    private IHierarchicalContentProvider getContentProvider(ISessionTokenProvider sessionTokenProvider) {
        if (this.contentProvider == null) {
            this.contentProvider = ServiceProvider.getHierarchicalContentProvider();
        }
        return this.contentProvider.cloneFor(sessionTokenProvider);
    }

    private static class DataSetTypeConfig {
        String fileListSubPath = "";
        IHierarchicalContentNodeFilter fileFilter = IHierarchicalContentNodeFilter.MATCH_ALL;

        private DataSetTypeConfig() {
        }
    }

    private final class DataSetFtpFolder
    extends AbstractFtpFolder {
        private final AbstractExternalData dataSet;
        private final FtpPathResolverContext resolverContext;

        private DataSetFtpFolder(String absolutePath, AbstractExternalData dataSet, FtpPathResolverContext resolverContext) {
            super(absolutePath);
            this.dataSet = dataSet;
            this.resolverContext = resolverContext;
            this.setLastModified(dataSet.getModificationDate().getTime());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<FtpFile> unsafeListFiles() throws RuntimeException {
            ArrayList<FtpFile> result = new ArrayList<FtpFile>();
            if (TemplateBasedDataSetResourceResolver.this.showParentsAndChildren) {
                DataSet dataSetWithMetaData = this.resolverContext.getDataSet(this.dataSet.getCode());
                this.addNodesOfType(TemplateBasedDataSetResourceResolver.PARENT_PREFIX, result, dataSetWithMetaData.getParentCodes());
                this.addNodesOfType(TemplateBasedDataSetResourceResolver.CHILD_PREFIX, result, dataSetWithMetaData.getChildrenCodes());
            }
            try (FtpFileEvaluationContext evalContext = TemplateBasedDataSetResourceResolver.this.createFtpFileEvaluationContext(this.resolverContext);){
                IHierarchicalContent hierarchicalContent = evalContext.getHierarchicalContent(this.dataSet, true);
                IHierarchicalContentNode rootNode = TemplateBasedDataSetResourceResolver.this.getDataSetFileListRoot(this.dataSet, hierarchicalContent);
                List childNodes = rootNode.getChildNodes();
                Cache cache = this.resolverContext.getCache();
                for (IHierarchicalContentNode childNode : childNodes) {
                    IHierarchicalContentNodeFilter fileFilter = TemplateBasedDataSetResourceResolver.this.getFileFilter(this.dataSet);
                    if (!fileFilter.accept(childNode)) continue;
                    result.add(FtpFileFactory.createFtpFile(this.dataSet.getCode(), this.absolutePath + "/" + childNode.getName(), childNode, hierarchicalContent, fileFilter, cache));
                }
            }
            return result;
        }

        private void addNodesOfType(String prefix, List<FtpFile> result, List<String> dataSetCodes) {
            if (dataSetCodes.isEmpty()) {
                return;
            }
            List<AbstractExternalData> dataSets = this.resolverContext.listDataSetsByCode(dataSetCodes);
            for (int i = 0; i < dataSets.size(); ++i) {
                AbstractExternalData ds = dataSets.get(i);
                String dataSetUniqueSuffix = TemplateBasedDataSetResourceResolver.this.evaluateTemplate(ds, null, TemplateBasedDataSetResourceResolver.this.computeDisambiguation(i));
                if (this.isPresentInPath(dataSetUniqueSuffix)) continue;
                String folderName = prefix + dataSetUniqueSuffix;
                result.add(new DataSetFtpFolder(this.absolutePath + "/" + folderName, ds, this.resolverContext));
            }
        }

        private boolean isPresentInPath(String suffix) {
            String dataSetUniqueSuffix = suffix + "/";
            String pathWithSeparator = this.absolutePath + "/";
            return pathWithSeparator.contains(dataSetUniqueSuffix);
        }
    }
}

