/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.server.graph;

import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.openbis.dss.generic.server.graph.ITabularDataGraph;
import ch.systemsx.cisd.openbis.dss.generic.server.graph.TabularDataGraphConfiguration;
import ch.systemsx.cisd.openbis.dss.generic.server.graph.TabularDataTickUnitSource;
import ch.systemsx.cisd.openbis.dss.generic.shared.utils.ITabularData;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.CodeAndLabel;
import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import org.apache.log4j.Logger;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.Axis;
import org.jfree.chart.axis.TickUnitSource;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.title.TextTitle;
import org.jfree.data.general.Dataset;
import org.jfree.data.xy.DefaultXYDataset;
import org.jfree.data.xy.XYDataset;

abstract class AbstractTabularDataGraph<T extends TabularDataGraphConfiguration>
implements ITabularDataGraph {
    protected static final Logger operationLog = LogFactory.getLogger((LogCategory)LogCategory.OPERATION, AbstractTabularDataGraph.class);
    private static final int SMALL_TICK_LABEL_FONT_SIZE = 7;
    private static final int SMALL_LABEL_FONT_SIZE = 9;
    private static final int SMALL_TITLE_FONT_SIZE = 12;
    private static final int SMALL_FONT_TRANSITION_SIZE = 400;
    protected final T configuration;
    protected final ITabularData fileLines;
    protected final OutputStream out;

    protected static final double parseDouble(String string) {
        double value;
        try {
            value = Double.parseDouble(string);
        }
        catch (NumberFormatException e) {
            value = Double.NaN;
        }
        return value;
    }

    protected static final boolean isFinite(double v) {
        return false == Double.isInfinite(v) && false == Double.isNaN(v);
    }

    protected AbstractTabularDataGraph(T configuration, ITabularData fileLines, OutputStream out) {
        this.configuration = configuration;
        this.fileLines = fileLines;
        this.out = out;
    }

    @Override
    public void generateImage() throws IOException {
        this.generateImage(((TabularDataGraphConfiguration)this.configuration).getImageWidth(), ((TabularDataGraphConfiguration)this.configuration).getImageHeight());
    }

    @Override
    public void generateImage(int imageWidth, int imageHeight) throws IOException {
        JFreeChart chart = this.createChart(imageWidth, imageHeight);
        ChartUtilities.writeChartAsPNG((OutputStream)this.out, (JFreeChart)chart, (int)imageWidth, (int)imageHeight);
    }

    protected T getConfiguration() {
        return this.configuration;
    }

    protected String getTitle() {
        return ((TabularDataGraphConfiguration)this.configuration).getTitle();
    }

    protected String getXAxisLabel() {
        return this.getColumnLabel(((TabularDataGraphConfiguration)this.configuration).getXAxisColumn());
    }

    protected String getYAxisLabel() {
        return this.getColumnLabel(((TabularDataGraphConfiguration)this.configuration).getYAxisColumn());
    }

    protected String getColumnLabel(CodeAndLabel columnCode) {
        String label = columnCode.getLabel();
        if (label != null) {
            return label;
        }
        int columnNumber = this.tryColumnNumberForHeader(columnCode);
        return columnNumber < 0 ? columnCode.getCode() : this.fileLines.getHeaderLabels()[columnNumber];
    }

    protected int tryXColumnNumber() {
        return this.tryColumnNumberForHeader(((TabularDataGraphConfiguration)this.configuration).getXAxisColumn());
    }

    protected int tryYColumnNumber() {
        return this.tryColumnNumberForHeader(((TabularDataGraphConfiguration)this.configuration).getYAxisColumn());
    }

    protected int tryColumnNumberForHeader(CodeAndLabel columnHeaderCode) {
        String code = columnHeaderCode.getCode();
        String[] headers = this.fileLines.getHeaderCodes();
        int i = 0;
        for (String header : headers) {
            if (code.equals(header)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    protected JFreeChart createErrorChart() {
        DefaultXYDataset dataset = new DefaultXYDataset();
        JFreeChart chart = ChartFactory.createXYAreaChart((String)"", (String)"", (String)"", (XYDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)false, (boolean)false);
        chart.setBackgroundPaint((Paint)Color.WHITE);
        chart.setBorderVisible(false);
        XYPlot plot = (XYPlot)chart.getPlot();
        plot.setBackgroundPaint((Paint)Color.WHITE);
        plot.setDomainGridlinesVisible(false);
        plot.setRangeGridlinesVisible(false);
        plot.setDomainCrosshairVisible(false);
        plot.setRangeCrosshairVisible(false);
        plot.setDomainZeroBaselineVisible(false);
        plot.setRangeZeroBaselineVisible(false);
        plot.setForegroundAlpha(0.0f);
        plot.setOutlineVisible(false);
        plot.setDomainAxis(null);
        plot.setRangeAxis(null);
        return chart;
    }

    protected JFreeChart createChart(int imageWidth, int imageHeight) {
        Dataset dataset = this.tryCreateChartDataset();
        if (null == dataset) {
            return this.createErrorChart();
        }
        JFreeChart chart = this.createDataChart(dataset);
        this.configureChart(chart, imageWidth, imageHeight);
        return chart;
    }

    protected abstract JFreeChart createDataChart(Dataset var1);

    protected abstract Dataset tryCreateChartDataset();

    protected boolean tryIterateOverFileLinesUsing(ILineProcessor proc) {
        int xColumn = this.tryXColumnNumber();
        int yColumn = this.tryYColumnNumber();
        if (xColumn < 0 || yColumn < 0) {
            if (xColumn < 0) {
                this.logFailureToFindColumnHeader(((TabularDataGraphConfiguration)this.configuration).getXAxisColumn());
            }
            if (yColumn < 0) {
                this.logFailureToFindColumnHeader(((TabularDataGraphConfiguration)this.configuration).getYAxisColumn());
            }
            return false;
        }
        List<String[]> lines = this.fileLines.getDataLines();
        int i = 0;
        for (String[] line : lines) {
            proc.processLine(line[xColumn], line[yColumn], i++);
        }
        return true;
    }

    protected void logFailureToFindColumnHeader(CodeAndLabel codeAndLabel) {
        Object[] headerCodes = this.fileLines.getHeaderCodes();
        operationLog.warn((Object)("Could not find column with header " + codeAndLabel + " among the " + headerCodes.length + " header(s): " + Arrays.toString(headerCodes)));
    }

    protected void configureChart(JFreeChart chart, int imageWidth, int imageHeight) {
        chart.setBackgroundPaint((Paint)Color.WHITE);
        if (imageWidth < 400) {
            TextTitle title = chart.getTitle();
            Font oldFont = title.getFont();
            title.setFont(new Font(oldFont.getName(), oldFont.getStyle(), 12));
        }
        XYPlot plot = (XYPlot)chart.getPlot();
        plot.setBackgroundPaint((Paint)Color.WHITE);
        plot.setDomainGridlinesVisible(false);
        plot.setRangeGridlinesVisible(true);
        plot.setRangeGridlinePaint((Paint)Color.LIGHT_GRAY);
        plot.setDomainCrosshairVisible(false);
        plot.setRangeCrosshairVisible(false);
        ValueAxis axis = plot.getDomainAxis();
        axis.setStandardTickUnits((TickUnitSource)new TabularDataTickUnitSource());
        axis.setAutoRange(true);
        this.configureAxisFonts(imageWidth, axis);
        axis = plot.getRangeAxis();
        axis.setStandardTickUnits((TickUnitSource)new TabularDataTickUnitSource());
        axis.setAutoRange(true);
        this.configureAxisFonts(imageWidth, axis);
    }

    protected void configureAxisFonts(int imageWidth, ValueAxis axis) {
        if (imageWidth < 400) {
            Font oldFont = axis.getLabelFont();
            axis.setLabelFont(new Font(oldFont.getName(), oldFont.getStyle(), 9));
            oldFont = axis.getTickLabelFont();
            axis.setTickLabelFont(new Font(oldFont.getName(), oldFont.getStyle(), 7));
        }
    }

    protected void setAxisLabelFontSize(Axis axis) {
        Font labelFont = axis.getLabelFont();
        axis.setLabelFont(this.cloneFontWithNewSize(labelFont, 10));
    }

    protected Font cloneFontWithNewSize(Font font, int newSize) {
        return new Font(font.getName(), font.getStyle(), newSize);
    }

    protected static interface ILineProcessor {
        public void processLine(String var1, String var2, int var3);
    }
}

