/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.server.graph;

import ch.systemsx.cisd.hcs.Location;
import ch.systemsx.cisd.openbis.dss.generic.server.graph.AbstractTabularDataGraph;
import ch.systemsx.cisd.openbis.dss.generic.server.graph.HeatmapDataset;
import ch.systemsx.cisd.openbis.dss.generic.server.graph.SpreadsheetColumnTickUnit;
import ch.systemsx.cisd.openbis.dss.generic.server.graph.TabularDataHeatmapConfiguration;
import ch.systemsx.cisd.openbis.dss.generic.server.graph.TabularDataTickUnit;
import ch.systemsx.cisd.openbis.dss.generic.server.graph.TabularDataTickUnitSource;
import ch.systemsx.cisd.openbis.dss.generic.shared.utils.ITabularData;
import java.awt.Color;
import java.awt.Paint;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.NumberTickUnit;
import org.jfree.chart.axis.TickUnitSource;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.LookupPaintScale;
import org.jfree.chart.renderer.PaintScale;
import org.jfree.chart.renderer.xy.XYBlockRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.title.PaintScaleLegend;
import org.jfree.chart.title.Title;
import org.jfree.data.Range;
import org.jfree.data.general.Dataset;
import org.jfree.data.xy.DefaultXYZDataset;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYZDataset;
import org.jfree.ui.RectangleAnchor;
import org.jfree.ui.RectangleEdge;
import org.jfree.ui.RectangleInsets;

public class TabularDataHeatmap
extends AbstractTabularDataGraph<TabularDataHeatmapConfiguration> {
    private static final int PAINT_SCALE_NUM_STEPS = 11;

    public TabularDataHeatmap(TabularDataHeatmapConfiguration configuration, ITabularData fileLines, OutputStream out) {
        super(configuration, fileLines, out);
    }

    protected XYZDataset tryCreateChartDataset() {
        int xColumn = this.tryXColumnNumber();
        int yColumn = this.tryYColumnNumber();
        int zColumn = this.tryColumnNumberForHeader(((TabularDataHeatmapConfiguration)this.configuration).getZAxisColumn());
        if (xColumn < 0 || yColumn < 0 || zColumn < 0) {
            if (xColumn < 0) {
                this.logFailureToFindColumnHeader(((TabularDataHeatmapConfiguration)this.configuration).getXAxisColumn());
            }
            if (yColumn < 0) {
                this.logFailureToFindColumnHeader(((TabularDataHeatmapConfiguration)this.configuration).getYAxisColumn());
            }
            if (zColumn < 0) {
                this.logFailureToFindColumnHeader(((TabularDataHeatmapConfiguration)this.configuration).getZAxisColumn());
            }
            return null;
        }
        HeatmapData data = this.parseData(xColumn, yColumn, zColumn);
        double[][] dataArray = this.convertHeatmapDataToArray(data);
        DefaultXYZDataset simpleDataset = new DefaultXYZDataset();
        simpleDataset.addSeries((Comparable)((Object)this.getTitle()), dataArray);
        HeatmapDataset dataset = new HeatmapDataset(simpleDataset);
        dataset.setRange(new Range(data.minZ, data.maxZ));
        return dataset;
    }

    @Override
    protected JFreeChart createDataChart(Dataset dataset) {
        JFreeChart chart = TabularDataHeatmap.createHeatmap(this.getTitle(), "", "", (HeatmapDataset)dataset, PlotOrientation.HORIZONTAL, false, false, false);
        return chart;
    }

    private static JFreeChart createHeatmap(String title, String xAxisLabel, String yAxisLabel, HeatmapDataset dataset, PlotOrientation orientation, boolean legend, boolean tooltips, boolean urls) {
        if (orientation == null) {
            throw new IllegalArgumentException("Null 'orientation' argument.");
        }
        NumberAxis xAxis = new NumberAxis(xAxisLabel);
        xAxis.setTickUnit((NumberTickUnit)new SpreadsheetColumnTickUnit(1.0));
        xAxis.setInverted(true);
        NumberAxis yAxis = new NumberAxis(yAxisLabel);
        XYBlockRenderer renderer = new XYBlockRenderer();
        renderer.setBlockAnchor(RectangleAnchor.CENTER);
        PaintScale paintScale = TabularDataHeatmap.getPaintScale(dataset);
        renderer.setPaintScale(paintScale);
        XYPlot plot = new XYPlot((XYDataset)dataset, (ValueAxis)xAxis, (ValueAxis)yAxis, null);
        plot.setOrientation(orientation);
        plot.setForegroundAlpha(1.0f);
        plot.setRenderer((XYItemRenderer)renderer);
        plot.setBackgroundPaint((Paint)Color.WHITE);
        plot.setRangeGridlinePaint((Paint)Color.BLACK);
        plot.setAxisOffset(new RectangleInsets(5.0, 5.0, 5.0, 5.0));
        JFreeChart chart = new JFreeChart(title, JFreeChart.DEFAULT_TITLE_FONT, (Plot)plot, legend);
        ChartFactory.getChartTheme().apply(chart);
        NumberAxis scaleAxis = new NumberAxis("Scale");
        scaleAxis.setRange(dataset.getRange());
        scaleAxis.setStandardTickUnits((TickUnitSource)new TabularDataTickUnitSource());
        scaleAxis.setTickUnit((NumberTickUnit)new TabularDataTickUnit(dataset.getRange().getLength() / 11.0));
        scaleAxis.setAutoRange(true);
        PaintScaleLegend psl = new PaintScaleLegend(paintScale, (ValueAxis)scaleAxis);
        psl.setMargin(new RectangleInsets(5.0, 5.0, 5.0, 5.0));
        psl.setPosition(RectangleEdge.RIGHT);
        psl.setAxisOffset(5.0);
        chart.addSubtitle((Title)psl);
        return chart;
    }

    private static PaintScale getPaintScale(HeatmapDataset dataset) {
        double upperBound;
        Range range = dataset.getRange();
        double lowerBound = range.getLowerBound();
        if (lowerBound == (upperBound = range.getUpperBound())) {
            LookupPaintScale paintScale = new LookupPaintScale(lowerBound, lowerBound + 1.0, (Paint)Color.WHITE);
            paintScale.add(lowerBound, (Paint)new Color(247, 247, 247));
            return paintScale;
        }
        LookupPaintScale paintScale = new LookupPaintScale(lowerBound, upperBound, (Paint)Color.WHITE);
        double binMin = range.getLowerBound();
        double binStep = range.getLength() / 11.0;
        paintScale.add(binMin, (Paint)new Color(5, 48, 97));
        paintScale.add(binMin += binStep, (Paint)new Color(33, 102, 172));
        paintScale.add(binMin += binStep, (Paint)new Color(67, 147, 195));
        paintScale.add(binMin += binStep, (Paint)new Color(146, 197, 222));
        paintScale.add(binMin += binStep, (Paint)new Color(209, 229, 240));
        paintScale.add(binMin += binStep, (Paint)new Color(247, 247, 247));
        paintScale.add(binMin += binStep, (Paint)new Color(253, 219, 199));
        paintScale.add(binMin += binStep, (Paint)new Color(244, 165, 130));
        paintScale.add(binMin += binStep, (Paint)new Color(214, 96, 77));
        paintScale.add(binMin += binStep, (Paint)new Color(178, 24, 43));
        paintScale.add(binMin += binStep, (Paint)new Color(103, 0, 31));
        return paintScale;
    }

    @Override
    protected void configureChart(JFreeChart chart, int imageWidth, int imageHeight) {
        super.configureChart(chart, imageWidth, imageHeight);
        PaintScaleLegend psl = (PaintScaleLegend)chart.getSubtitle(0);
        ValueAxis axis = psl.getAxis();
        this.configureAxisFonts(imageWidth, axis);
    }

    private HeatmapData parseData(int xColumn, int yColumn, int zColumn) {
        HeatmapData heatmapData = new HeatmapData();
        heatmapData.maxX = 0;
        heatmapData.maxY = 0;
        boolean areZBoundsInitialized = false;
        List<String[]> lines = this.fileLines.getDataLines();
        for (String[] line : lines) {
            double zValue;
            HeatmapElement element = new HeatmapElement();
            if (((TabularDataHeatmapConfiguration)this.configuration).isXYSplit()) {
                try {
                    element.x = (int)Float.parseFloat(line[xColumn]);
                }
                catch (NumberFormatException ex) {
                    element.x = Location.tryCreateLocationFromTransposedMatrixCoordinate((String)(line[xColumn] + "1")).getY();
                }
                element.y = (int)Float.parseFloat(line[yColumn]);
            } else {
                Location loc = Location.tryCreateLocationFromTransposedMatrixCoordinate((String)line[xColumn]);
                element.x = loc.getY();
                element.y = loc.getX();
            }
            element.z = TabularDataHeatmap.parseDouble(line[zColumn]);
            if (element.x > heatmapData.maxX) {
                heatmapData.maxX = element.x;
            }
            if (element.y > heatmapData.maxY) {
                heatmapData.maxY = element.y;
            }
            if (!TabularDataHeatmap.isFinite(zValue = element.z)) continue;
            areZBoundsInitialized = this.updateZMinMaxBounds(heatmapData, areZBoundsInitialized, zValue);
            heatmapData.elements.add(element);
        }
        return heatmapData;
    }

    private boolean updateZMinMaxBounds(HeatmapData heatmapData, boolean areZBoundsInitialized, double finiteDouble) {
        if (!areZBoundsInitialized) {
            heatmapData.minZ = finiteDouble;
            heatmapData.maxZ = finiteDouble;
            return true;
        }
        if (finiteDouble < heatmapData.minZ) {
            heatmapData.minZ = finiteDouble;
        }
        if (finiteDouble > heatmapData.maxZ) {
            heatmapData.maxZ = finiteDouble;
        }
        return areZBoundsInitialized;
    }

    private double[][] convertHeatmapDataToArray(HeatmapData data) {
        double[][] dataArray = new double[3][];
        double[] xArray = new double[data.elements.size()];
        double[] yArray = new double[data.elements.size()];
        double[] zArray = new double[data.elements.size()];
        dataArray[0] = xArray;
        dataArray[1] = yArray;
        dataArray[2] = zArray;
        int i = 0;
        for (HeatmapElement elt : data.elements) {
            xArray[i] = elt.x;
            yArray[i] = elt.y;
            zArray[i++] = elt.z;
        }
        return dataArray;
    }

    private class HeatmapData {
        private int maxX;
        private int maxY;
        private double minZ = 0.0;
        private double maxZ = 0.0;
        private final ArrayList<HeatmapElement> elements = new ArrayList();

        private HeatmapData() {
        }
    }

    private class HeatmapElement {
        private int x;
        private int y;
        private double z;

        private HeatmapElement() {
        }
    }
}

