/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.server.graph;

import ch.systemsx.cisd.openbis.dss.generic.server.graph.AbstractTabularDataGraph;
import ch.systemsx.cisd.openbis.dss.generic.server.graph.TabularDataHistogramConfiguration;
import ch.systemsx.cisd.openbis.dss.generic.shared.utils.ITabularData;
import java.io.OutputStream;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.StandardXYBarPainter;
import org.jfree.chart.renderer.xy.XYBarPainter;
import org.jfree.chart.renderer.xy.XYBarRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.general.Dataset;
import org.jfree.data.statistics.HistogramDataset;
import org.jfree.data.xy.IntervalXYDataset;

public class TabularDataHistogram
extends AbstractTabularDataGraph<TabularDataHistogramConfiguration> {
    public TabularDataHistogram(TabularDataHistogramConfiguration configuration, ITabularData fileLines, OutputStream out) {
        super(configuration, fileLines, out);
    }

    protected HistogramDataset tryCreateChartDataset() {
        final double[] series = new double[this.fileLines.getDataLines().size()];
        final int[] finiteValueCount = new int[]{0};
        boolean success = this.tryIterateOverFileLinesUsing(new AbstractTabularDataGraph.ILineProcessor(){

            @Override
            public void processLine(String xString, String yString, int index) {
                double v;
                series[index] = v = AbstractTabularDataGraph.parseDouble(xString);
                if (AbstractTabularDataGraph.isFinite(v)) {
                    finiteValueCount[0] = finiteValueCount[0] + 1;
                }
            }
        });
        if (!success) {
            return null;
        }
        HistogramDataset dataset = new HistogramDataset();
        if (finiteValueCount[0] > 0) {
            dataset.addSeries((Comparable)((Object)this.getTitle()), series, ((TabularDataHistogramConfiguration)this.configuration).getNumberOfBins());
        }
        return dataset;
    }

    @Override
    protected JFreeChart createDataChart(Dataset dataset) {
        JFreeChart chart = ChartFactory.createHistogram((String)this.getTitle(), (String)this.getXAxisLabel(), (String)"Count", (IntervalXYDataset)((HistogramDataset)dataset), (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)false, (boolean)false);
        XYItemRenderer r = ((XYPlot)chart.getPlot()).getRenderer();
        if (r instanceof XYBarRenderer) {
            XYBarRenderer renderer = (XYBarRenderer)r;
            renderer.setShadowVisible(false);
            renderer.setBarPainter((XYBarPainter)new StandardXYBarPainter());
        }
        return chart;
    }
}

