/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.server.graph;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import org.jfree.chart.axis.NumberTickUnit;

public class TabularDataTickUnit
extends NumberTickUnit {
    private static final long serialVersionUID = 1L;
    private static final double LOG_10_VALUE = Math.log(10.0);
    private static final int largeScientificNotationTransition = 6;
    private static final int smallScientificNotationTransition = 3;

    public TabularDataTickUnit(double size) {
        this(size, Math.abs(Math.ceil(Math.log(size) / LOG_10_VALUE)), size >= 1.0);
    }

    public TabularDataTickUnit(double size, double precision, boolean greaterThan1) {
        super(size, (NumberFormat)TabularDataTickUnit.getNumberFormat(precision, greaterThan1));
    }

    private static DecimalFormat getNumberFormat(double precision, boolean greaterThan1) {
        DecimalFormat numberFormat = greaterThan1 ? (precision > 6.0 ? new DecimalFormat("0.0##E0") : TabularDataTickUnit.getStandardNumberFormat((int)precision, greaterThan1)) : (precision > 3.0 ? new DecimalFormat("0.0##E0") : TabularDataTickUnit.getStandardNumberFormat((int)precision, greaterThan1));
        return numberFormat;
    }

    private static DecimalFormat getStandardNumberFormat(int precision, boolean greaterThan1) {
        StringBuilder sb = new StringBuilder();
        if (greaterThan1) {
            for (int i = 0; i < precision; ++i) {
                sb.append("#");
            }
            sb.append("0");
        } else {
            sb.append("0.0");
            for (int i = 0; i < precision - 1; ++i) {
                sb.append("0");
            }
        }
        return new DecimalFormat(sb.toString());
    }

    public String valueToString(double value) {
        return super.valueToString(value);
    }
}

