/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.server.oaipmh;

import ch.systemsx.cisd.openbis.dss.generic.server.oaipmh.IAuthenticationHandler;
import ch.systemsx.cisd.openbis.dss.generic.shared.ServiceProvider;
import ch.systemsx.cisd.openbis.generic.shared.dto.SessionContextDTO;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class AnonymousAuthenticationHandler
implements IAuthenticationHandler {
    private static final String PROPERTY_USER = "user";
    private static final String PROPERTY_PASSWORD = "password";
    private String user;
    private String password;

    @Override
    public void init(Properties properties) {
        this.user = (String)properties.get(PROPERTY_USER);
        if (this.user == null || this.user.isEmpty()) {
            throw new IllegalArgumentException("'user' cannot be null or empty.");
        }
        this.password = (String)properties.get(PROPERTY_PASSWORD);
    }

    @Override
    public SessionContextDTO handle(HttpServletRequest request, HttpServletResponse response) {
        SessionContextDTO session = ServiceProvider.getOpenBISService().tryAuthenticate(this.user, this.password);
        if (session != null) {
            return session;
        }
        throw new IllegalArgumentException("Incorrect user or password specified in " + this.getClass().getName() + " configuration. Please check the plugin.properties.");
    }
}

