/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.server.oaipmh;

import ch.systemsx.cisd.base.exceptions.CheckedExceptionTunnel;
import ch.systemsx.cisd.openbis.dss.generic.server.oaipmh.IAuthenticationHandler;
import ch.systemsx.cisd.openbis.dss.generic.shared.ServiceProvider;
import ch.systemsx.cisd.openbis.generic.shared.dto.SessionContextDTO;
import java.io.IOException;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.binary.Base64;

public class BasicHttpAuthenticationHandler
implements IAuthenticationHandler {
    @Override
    public void init(Properties properties) {
    }

    @Override
    public SessionContextDTO handle(HttpServletRequest req, HttpServletResponse resp) {
        try {
            String authorization = req.getHeader("Authorization");
            if (authorization != null && authorization.trim().length() > 0) {
                Pattern pattern = Pattern.compile("Basic (.+)");
                Matcher matcher = pattern.matcher(authorization);
                if (matcher.matches()) {
                    String encoded = matcher.group(1);
                    String decoded = new String(Base64.decodeBase64((byte[])encoded.getBytes()));
                    String[] parts = decoded.split(":");
                    if (parts != null && parts.length == 2) {
                        String user = parts[0];
                        String password = parts[1];
                        SessionContextDTO session = ServiceProvider.getOpenBISService().tryAuthenticate(user, password);
                        if (session == null) {
                            resp.setHeader("WWW-Authenticate", "Basic realm=\"OAI-PMH\"");
                            resp.sendError(401, "");
                            return null;
                        }
                        return session;
                    }
                    throw new IllegalArgumentException("Authorization header had an incorrect value: " + authorization);
                }
                throw new IllegalArgumentException("Authorization header had an incorrect value: " + authorization);
            }
            resp.setHeader("WWW-Authenticate", "Basic realm=\"OAI-PMH\"");
            resp.sendError(401, "");
            return null;
        }
        catch (IOException e) {
            throw CheckedExceptionTunnel.wrapIfNecessary((Exception)e);
        }
    }
}

