/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.server.oaipmh;

import ch.systemsx.cisd.openbis.dss.generic.server.oaipmh.IRequestHandler;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.jython.IPluginScriptRunnerFactory;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.jython.IRequestHandlerPluginScriptRunner;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.jython.PluginScriptRunnerFactory;
import ch.systemsx.cisd.openbis.dss.generic.shared.DataSetProcessingContext;
import ch.systemsx.cisd.openbis.dss.generic.shared.IDataStoreServiceInternal;
import ch.systemsx.cisd.openbis.dss.generic.shared.IShareIdManager;
import ch.systemsx.cisd.openbis.dss.generic.shared.ServiceProvider;
import ch.systemsx.cisd.openbis.generic.shared.dto.SessionContextDTO;
import java.io.File;
import java.util.HashMap;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class JythonBasedRequestHandler
implements IRequestHandler {
    private static final String SCRIPT_PATH_PARAMETER_NAME = "script-path";
    private static final String PROPERTIES_VARIABLE_NAME = "properties";
    private static final String USER_SESSION_TOKEN = "userSessionToken";
    protected Properties properties;
    private String scriptPath;

    @Override
    public void init(Properties properties) {
        this.properties = properties;
        this.scriptPath = this.initScriptPath(properties);
    }

    private String initScriptPath(Properties properties) {
        String path = properties.getProperty(SCRIPT_PATH_PARAMETER_NAME);
        if (path == null || path.trim().length() == 0) {
            throw new IllegalArgumentException("Script path is null or empty");
        }
        File file = new File(path);
        if (!file.exists()) {
            throw new IllegalArgumentException("Script path: '" + file.getAbsolutePath() + "' does not exist");
        }
        if (file.isDirectory()) {
            throw new IllegalArgumentException("Script path: '" + file.getAbsolutePath() + "' represents a directory");
        }
        return path;
    }

    @Override
    public void handle(SessionContextDTO session, HttpServletRequest req, HttpServletResponse resp) {
        this.handleWithScript(session, req, resp, this.getScriptRunnerFactory(this.scriptPath));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleWithScript(SessionContextDTO session, HttpServletRequest req, HttpServletResponse resp, IPluginScriptRunnerFactory factory) {
        IShareIdManager manager = ServiceProvider.getShareIdManager();
        try {
            IDataStoreServiceInternal service = ServiceProvider.getDataStoreService();
            DataSetProcessingContext context = new DataSetProcessingContext(ServiceProvider.getHierarchicalContentProvider(), service.getDataSetDirectoryProvider(), service.getSessionWorkspaceProvider(session.getSessionToken()), new HashMap<String, String>(), service.createEMailClient(), session.getUserName(), session.getUserEmail(), session.getSessionToken());
            IRequestHandlerPluginScriptRunner runner = factory.createRequestHandlerPluginRunner(context);
            this.setVariables(runner, session);
            runner.handle(req, resp);
        }
        finally {
            manager.releaseLocks();
        }
    }

    protected void setVariables(IRequestHandlerPluginScriptRunner runner, SessionContextDTO session) {
        runner.setVariable(PROPERTIES_VARIABLE_NAME, this.properties);
        runner.setVariable(USER_SESSION_TOKEN, session.getSessionToken());
    }

    protected IPluginScriptRunnerFactory getScriptRunnerFactory(String scriptPath) {
        return new PluginScriptRunnerFactory(scriptPath);
    }
}

